/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.swift.IBlobStoreListenerNotifier;
import org.geowebcache.swift.SwiftBlobStoreInfo;
import org.geowebcache.swift.SwiftDeleteTask;
import org.geowebcache.swift.SwiftTile;
import org.geowebcache.swift.SwiftUploadTask;
import org.geowebcache.util.TMSKeyBuilder;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedSwiftBlobStore;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.BulkApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;

public class SwiftBlobStore
implements BlobStore {
    static final Logger logg = Logging.getLogger((String)SwiftBlobStore.class.getName());
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();
    private final SwiftBlobStoreInfo config;
    private final TMSKeyBuilder keyBuilder;
    private volatile boolean shutDown;
    private SwiftApi swiftApi;
    private ObjectApi objectApi;
    private BulkApi bulkApi;
    private RegionScopedBlobStoreContext blobStoreContext;
    private RegionScopedSwiftBlobStore blobStore;
    private ThreadPoolExecutor executor;
    private BlockingQueue<Runnable> taskQueue;

    public SwiftBlobStore(SwiftBlobStoreInfo config, TileLayerDispatcher layers) {
        Preconditions.checkNotNull((Object)((Object)config));
        Preconditions.checkNotNull((Object)layers);
        String prefix = config.getPrefix();
        this.keyBuilder = new TMSKeyBuilder(prefix == null ? "" : prefix, layers);
        this.config = config;
        this.taskQueue = new LinkedBlockingQueue<Runnable>(1000);
        this.executor = new ThreadPoolExecutor(2, 32, 10L, TimeUnit.SECONDS, this.taskQueue, new ThreadPoolExecutor.CallerRunsPolicy());
        this.initApis();
    }

    private void initApis() {
        if (this.config.isValid()) {
            this.swiftApi = this.config.buildApi();
            this.objectApi = this.swiftApi.getObjectApi(this.config.getRegion(), this.config.getContainer());
            this.bulkApi = this.swiftApi.getBulkApi(this.config.getRegion());
            this.blobStoreContext = this.config.getBlobStore();
            this.blobStore = (RegionScopedSwiftBlobStore)this.blobStoreContext.getBlobStore(this.config.getRegion());
        }
    }

    public void destroy() {
        try {
            this.shutDown = true;
            this.swiftApi.close();
            this.blobStoreContext.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error closing connection.", e);
        }
    }

    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean removeListener(BlobStoreListener listener) {
        return this.listeners.removeListener(listener);
    }

    public void put(TileObject obj) throws StorageException {
        try {
            SwiftTile tile = new SwiftTile(obj);
            String key = this.keyBuilder.forTile(obj);
            this.executor.execute(new SwiftUploadTask(key, tile, this.listeners, this.objectApi));
            log.fine("Added upload request to task queue. Queue length is now " + this.taskQueue.size());
        }
        catch (IOException e) {
            throw new StorageException("Could not process tile object for upload.");
        }
    }

    public boolean get(TileObject obj) throws StorageException {
        String key = this.keyBuilder.forTile(obj);
        SwiftObject object = this.objectApi.get(key);
        if (object == null) {
            return false;
        }
        try (Payload in = object.getPayload();
             InputStream inStream = in.openStream();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)inStream);
            obj.setBlobSize(bytes.length);
            obj.setBlob((Resource)new ByteArrayResource(bytes));
            obj.setCreated(object.getLastModified().getTime());
        }
        catch (IOException e) {
            throw new StorageException("Error getting " + key, (Throwable)e);
        }
        return true;
    }

    public boolean delete(final TileRange tileRange) {
        String coordsPrefix = this.keyBuilder.coordinatesPrefix(tileRange, true);
        if (this.objectApi.get(coordsPrefix) == null) {
            return false;
        }
        AbstractIterator<long[]> tileLocations = new AbstractIterator<long[]>(){
            private final TileRangeIterator trIter;
            {
                this.trIter = new TileRangeIterator(tileRange, new int[]{1, 1});
            }

            protected long[] computeNext() {
                long[] gridLoc = this.trIter.nextMetaGridLocation(new long[3]);
                return gridLoc == null ? (long[])this.endOfData() : gridLoc;
            }
        };
        if (this.listeners.isEmpty()) {
            UnmodifiableIterator partition = Iterators.partition((Iterator)tileLocations, (int)1000);
            TileToKey tileToKey = new TileToKey(coordsPrefix, tileRange.getMimeType());
            while (partition.hasNext() && !this.shutDown) {
                List locations = (List)partition.next();
                List keys = Lists.transform((List)locations, (Function)tileToKey);
                this.bulkApi.bulkDelete((Iterable)keys);
            }
        } else {
            String layerName = tileRange.getLayerName();
            String gridSetId = tileRange.getGridSetId();
            String format = tileRange.getMimeType().getFormat();
            Map parameters = tileRange.getParameters();
            while (tileLocations.hasNext()) {
                long[] xyz = (long[])tileLocations.next();
                TileObject tile = TileObject.createQueryTileObject((String)layerName, (long[])xyz, (String)gridSetId, (String)format, (Map)parameters);
                tile.setParametersId(tileRange.getParametersId());
                this.delete(tile);
            }
        }
        return true;
    }

    public boolean delete(String layerName) {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        String layerPrefix = this.keyBuilder.forLayer(layerName);
        boolean deletionSuccessful = this.deleteByPath(layerPrefix, () -> this.listeners.sendLayerDeleted(layerName));
        return deletionSuccessful;
    }

    public boolean deleteByGridsetId(String layerName, String gridSetId) {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        Preconditions.checkNotNull((Object)gridSetId, (Object)"gridSetId");
        String gridsetPrefix = this.keyBuilder.forGridset(layerName, gridSetId);
        boolean deletedSuccessfully = this.deleteByPath(gridsetPrefix, () -> this.listeners.sendGridSubsetDeleted(layerName, gridSetId));
        return deletedSuccessfully;
    }

    public boolean delete(TileObject obj) {
        String tilePrefix = this.keyBuilder.forTile(obj);
        boolean deleted = this.deleteByPath(tilePrefix, () -> this.listeners.sendTileDeleted(obj));
        return deleted;
    }

    public boolean rename(String oldLayerName, String newLayerName) {
        log.fine("No need to rename layers, SwiftBlobStore uses layer id as key root");
        if (this.objectApi.get(oldLayerName) != null) {
            this.listeners.sendLayerRenamed(oldLayerName, newLayerName);
        }
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException("clear() should not be called");
    }

    @Nullable
    public String getLayerMetadata(String layerName, String key) {
        SwiftObject layer = this.objectApi.get(layerName);
        if (layer == null) {
            return null;
        }
        if (layer.getMetadata() == null) {
            return null;
        }
        return (String)layer.getMetadata().get(key);
    }

    public void putLayerMetadata(String layerName, String key, String value) {
        SwiftObject layer = this.objectApi.get(layerName);
        if (layer == null) {
            return;
        }
        HashMap<String, String> metaData = layer.getMetadata();
        if (metaData == null) {
            metaData = new HashMap<String, String>();
        }
        metaData.put(key, value);
        this.objectApi.updateMetadata(layerName, metaData);
    }

    public boolean layerExists(String layerName) {
        return this.objectApi.get(layerName) != null;
    }

    public Map<String, Optional<Map<String, String>>> getParametersMapping(String layerName) {
        String prefix = this.keyBuilder.parametersMetadataPrefix(layerName);
        ListContainerOptions options = new ListContainerOptions();
        options.prefix(prefix);
        HashMap<String, Optional<Map<String, String>>> paramMapping = new HashMap<String, Optional<Map<String, String>>>();
        for (SwiftObject obj : this.objectApi.list(options)) {
            paramMapping.put(obj.getName(), Optional.of(obj.getMetadata()));
        }
        return paramMapping;
    }

    public boolean deleteByParametersId(String layerName, String parametersId) {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        Preconditions.checkNotNull((Object)parametersId, (Object)"parametersId");
        boolean deletionSuccessful = this.keyBuilder.forParameters(layerName, parametersId).stream().map(path -> this.deleteByPath((String)path)).reduce(Boolean::logicalAnd).orElse(false);
        if (deletionSuccessful) {
            this.listeners.sendParametersDeleted(layerName, parametersId);
        }
        return deletionSuccessful;
    }

    protected boolean deleteByPath(String path, IBlobStoreListenerNotifier notifier) {
        for (Object task : this.taskQueue.toArray()) {
            String key;
            if (!(task instanceof SwiftUploadTask) || !(key = ((SwiftUploadTask)task).getKey()).startsWith(path)) continue;
            log.fine(this.taskQueue.remove(task) ? "Cancelled upload of " + key : "Failed to cancel upload of " + key);
        }
        this.executor.execute(new SwiftDeleteTask(this.blobStore, path, this.config.getContainer(), notifier));
        log.fine(String.format("Deleting Swift tile cache at %s/%s", this.config.getContainer(), path));
        return true;
    }

    protected boolean deleteByPath(String path) {
        return this.deleteByPath(path, null);
    }

    private static class TileToKey
    implements Function<long[], String> {
        private final String coordsPrefix;
        private final String extension;

        public TileToKey(String coordsPrefix, MimeType mimeType) {
            this.coordsPrefix = coordsPrefix;
            this.extension = mimeType.getInternalName();
        }

        public String apply(long[] loc) {
            return String.format("%s%d/%d/%d.%s", this.coordsPrefix, loc[2], loc[0], loc[1], this.extension);
        }
    }
}

