/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import com.google.common.base.Strings;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.Info;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.swift.SwiftBlobStoreInfo;

public class SwiftBlobStoreConfigProvider
implements XMLConfigurationProvider {
    private static GeoWebCacheEnvironment gwcEnvironment = null;
    private static final SingleValueConverter EnvironmentNullableBooleanConverter = new BooleanConverter(){

        public Object fromString(String str) {
            if (Strings.isNullOrEmpty((String)(str = SwiftBlobStoreConfigProvider.resolveFromEnv(str)))) {
                return null;
            }
            return super.fromString(str);
        }
    };
    private static final SingleValueConverter EnvironmentStringConverter = new StringConverter(){

        public Object fromString(String str) {
            if (Strings.isNullOrEmpty((String)(str = SwiftBlobStoreConfigProvider.resolveFromEnv(str)))) {
                return null;
            }
            return str;
        }
    };

    private static String resolveFromEnv(String str) {
        if (gwcEnvironment == null) {
            gwcEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
        }
        if (gwcEnvironment != null && str != null && GeoWebCacheEnvironment.ALLOW_ENV_PARAMETRIZATION) {
            Object result = gwcEnvironment.resolveValue((Object)str);
            if (result == null) {
                return null;
            }
            return result.toString();
        }
        return str;
    }

    public XStream getConfiguredXStream(XStream xs) {
        xs.alias("SwiftBlobStore", SwiftBlobStoreInfo.class);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "container", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "provider", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "region", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "keystoneVersion", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "keystoneScope", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "identity", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "password", EnvironmentStringConverter);
        xs.registerLocalConverter(SwiftBlobStoreInfo.class, "prefix", EnvironmentStringConverter);
        xs.registerLocalConverter(BlobStoreInfo.class, "enabled", EnvironmentNullableBooleanConverter);
        xs.aliasField("id", SwiftBlobStoreInfo.class, "name");
        return xs;
    }

    public boolean canSave(Info i) {
        return i instanceof SwiftBlobStoreInfo;
    }
}

