/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.swift.SwiftBlobStore;
import org.jclouds.ContextBuilder;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.openstack.swift.v1.features.ContainerApi;

public class SwiftBlobStoreInfo
extends BlobStoreInfo {
    static Logger log = Logging.getLogger((String)SwiftBlobStoreInfo.class.getName());
    private static final long serialVersionUID = 9072751143836460389L;
    private static final String provider = "openstack-swift";
    private static final String keystoneDomainName = "Default";
    private String container;
    private String prefix;
    private String region;
    private String keystoneVersion;
    private String keystoneScope;
    private String identity;
    private String password;
    private String endpoint;

    public SwiftBlobStoreInfo() {
    }

    public SwiftBlobStoreInfo(String id) {
        super(id);
    }

    public String getContainer() {
        return this.container;
    }

    public BlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) {
        Preconditions.checkNotNull((Object)layers);
        Preconditions.checkState((this.getName() != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Can't call SwiftBlobStoreConfig.createInstance() if blob store is not enabled");
        return new SwiftBlobStore(this, layers);
    }

    @Nullable
    public String getPrefix() {
        return this.prefix;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    public SwiftApi buildApi() {
        Properties overrides = new Properties();
        overrides.put("jclouds.keystone.version", this.keystoneVersion);
        overrides.put("jclouds.keystone.scope", this.keystoneScope);
        overrides.put("jclouds.keystone.project-domain-name", keystoneDomainName);
        overrides.put("jclouds.max-connections-per-context", (Object)32);
        overrides.put("jclouds.max-retries", (Object)0);
        SwiftApi context = (SwiftApi)ContextBuilder.newBuilder((String)provider).endpoint(this.endpoint).credentials(this.identity, this.password).overrides(overrides).buildApi(SwiftApi.class);
        ContainerApi containerApi = context.getContainerApi(this.region);
        if (containerApi.get(this.container) == null) {
            containerApi.create(this.container);
        }
        return context;
    }

    public RegionScopedBlobStoreContext getBlobStore() {
        Properties overrides = new Properties();
        overrides.put("jclouds.keystone.version", this.keystoneVersion);
        overrides.put("jclouds.keystone.scope", this.keystoneScope);
        overrides.put("jclouds.keystone.project-domain-name", keystoneDomainName);
        ContextBuilder builder = ContextBuilder.newBuilder((String)provider).endpoint(this.endpoint).credentials(this.identity, this.password).overrides(overrides);
        return (RegionScopedBlobStoreContext)builder.build(RegionScopedBlobStoreContext.class);
    }

    public String getLocation() {
        String bucket = this.getContainer();
        String prefix = this.getPrefix();
        if (prefix == null) {
            return String.format("bucket: %s", bucket);
        }
        return String.format("bucket: %s prefix: %s", bucket, prefix);
    }

    public boolean isValid() {
        List<String> fields = Arrays.asList(this.endpoint, this.identity, this.password, this.region, this.container, this.keystoneVersion, this.keystoneScope);
        return !fields.contains(null) && !fields.contains("");
    }
}

