/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.swift.IBlobStoreListenerNotifier;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedSwiftBlobStore;

class SwiftDeleteTask
implements Runnable {
    static final Logger log = Logging.getLogger((String)SwiftDeleteTask.class.getName());
    static final String logStr = "%s, %s, %dms";
    private static final int RETRIES = 5;
    private final RegionScopedSwiftBlobStore blobStore;
    private final String path;
    private final String container;
    private final IBlobStoreListenerNotifier notifier;

    SwiftDeleteTask(RegionScopedSwiftBlobStore blobStore, String path, String container, IBlobStoreListenerNotifier notifier) {
        this.blobStore = blobStore;
        this.path = path;
        this.container = container;
        this.notifier = notifier;
    }

    @Override
    public void run() {
        ListContainerOptions options = new ListContainerOptions().prefix(this.path).recursive();
        int delayMs = 1000;
        boolean deleted = false;
        for (int retry = 0; retry < 5 && !deleted; ++retry) {
            this.blobStore.clearContainer(this.container, options);
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                log.fine(e.getMessage());
            }
            delayMs *= 2;
            deleted = this.blobStore.list(this.container, options).isEmpty();
        }
        if (deleted) {
            log.info(String.format("Deleted Swift tile cache at %s/%s", this.container, this.path));
            if (this.notifier != null) {
                this.notifier.notifyListeners();
            }
        } else {
            log.log(Level.SEVERE, String.format("Failed to delete Swift tile cache at %s/%s after %d retries.", this.container, this.path, 5));
        }
    }
}

