/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.jetty;

import java.io.File;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.geotools.util.logging.Logging;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JettyRule
extends ExternalResource {
    private static final String JETTY_PORT_PROPERTY = "jetty.port";
    private static final Logger log = Logging.getLogger((String)JettyRule.class.getName());
    Integer port = null;
    TemporaryFolder temp = new TemporaryFolder();
    Server jettyServer;
    private File confDir;
    private File cacheDir;
    private File workDir;
    Initializer<File> confInit;
    Initializer<File> cacheInit;

    public int getPort() {
        return ((ServerConnector)this.getServer().getConnectors()[0]).getLocalPort();
    }

    public JettyRule() {
        this(d -> {}, d -> {});
    }

    public JettyRule(Initializer<File> confInit, Initializer<File> cacheInit) {
        this.confInit = confInit;
        this.cacheInit = cacheInit;
    }

    public Statement apply(Statement base, Description description) {
        return this.temp.apply(super.apply(base, description), description);
    }

    public Server getServer() {
        if (this.jettyServer == null) {
            throw new IllegalStateException();
        }
        return this.jettyServer;
    }

    public URI getUri() {
        try {
            return new URI("http", null, "localhost", this.getPort(), "/geowebcache/", null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void before() throws Exception {
        this.confDir = this.temp.newFolder("conf");
        this.cacheDir = this.temp.newFolder("cache");
        this.workDir = this.temp.newFolder("work");
        this.confInit.accept(this.confDir);
        this.cacheInit.accept(this.cacheDir);
        Integer port = Integer.getInteger(JETTY_PORT_PROPERTY, 0);
        this.jettyServer = new Server();
        try {
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            ServerConnector http = new ServerConnector(this.jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            http.setPort(port.intValue());
            http.setAcceptQueueSize(100);
            http.setIdleTimeout(3600000L);
            this.jettyServer.setConnectors(new Connector[]{http});
            WebAppContext wah = new WebAppContext();
            wah.setContextPath("/geowebcache");
            wah.setWar("src/main/webapp");
            wah.getInitParams().put("GEOWEBCACHE_CONF_DIR", this.confDir.getCanonicalPath());
            wah.getInitParams().put("GEOWEBCACHE_CACHE_DIR", this.cacheDir.getCanonicalPath());
            this.jettyServer.setHandler((Handler)wah);
            wah.setTempDirectory(this.workDir);
            QueuedThreadPool tp = new QueuedThreadPool();
            tp.setMinThreads(50);
            tp.setMaxThreads(50);
            this.jettyServer.start();
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                log.log(Level.SEVERE, "Could not bind to port " + port + ", " + e.getMessage() + ", Set via property jetty.port");
            }
            if (this.jettyServer != null) {
                try {
                    this.jettyServer.stop();
                }
                catch (Exception e1) {
                    e1.addSuppressed(e);
                    throw e1;
                }
            }
            throw e;
        }
    }

    protected void after() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not stop Jetty server: " + e.getMessage());
        }
    }

    public static interface Initializer<T> {
        public void accept(T var1) throws Exception;

        default public Initializer<T> andThen(Consumer<? super T> afterInit) {
            Objects.requireNonNull(afterInit);
            return toInit -> {
                this.accept(toInit);
                afterInit.accept(toInit);
            };
        }

        default public Consumer<T> makeSafe(Consumer<Exception> handler) {
            return toInit -> {
                try {
                    this.accept(toInit);
                }
                catch (Exception e) {
                    handler.accept(e);
                }
            };
        }
    }
}

