/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.jetty;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.custommonkey.xmlunit.XMLUnit;
import org.geowebcache.jetty.HttpClientRule;
import org.geowebcache.jetty.JettyRule;
import org.geowebcache.util.FileMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RestIntegrationTest {
    @ClassRule
    public static JettyRule jetty = new JettyRule();
    @Rule
    public HttpClientRule anonymous = HttpClientRule.anonymous();
    @Rule
    public HttpClientRule admin = new HttpClientRule("geowebcache", "secured", "admin");
    @Rule
    public HttpClientRule badPassword = new HttpClientRule("geowebcache", "notTheRightPassword", "badPassword");
    @Rule
    public HttpClientRule notAUser = new HttpClientRule("notARealUser", "somePassword", "notAUser");
    @ClassRule
    public static TemporaryFolder temp = new TemporaryFolder();
    private SimpleNamespaceContext nsContext;

    @Before
    public void setUp() throws Exception {
        this.nsContext = new SimpleNamespaceContext();
        this.nsContext.bindNamespaceUri("atom", "http://www.w3.org/2005/Atom");
        this.nsContext.bindNamespaceUri("wmts", "http://www.opengis.net/wmts/1.0");
        this.nsContext.bindNamespaceUri("ows", "http://www.opengis.net/ows/1.1");
        String globalUpdate = "<global>\n  <serviceInformation>\n    <title>GeoWebCache</title>\n    <description>GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and\n      formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</description>\n    <keywords>\n      <string>WMS</string>\n      <string>WFS</string>\n      <string>WMTS</string>\n      <string>GEOWEBCACHE</string>\n    </keywords>\n    <serviceProvider>\n      <providerName>John Smith inc.</providerName>\n      <providerSite>http://www.example.com/</providerSite>\n      <serviceContact>\n        <individualName>John Smith</individualName>\n        <positionName>Geospatial Expert</positionName>\n        <addressType>Work</addressType>\n        <addressStreet>1 Bumpy St.</addressStreet>\n        <addressCity>Hobart</addressCity>\n        <addressAdministrativeArea>TAS</addressAdministrativeArea>\n        <addressPostalCode>7005</addressPostalCode>\n        <addressCountry>Australia</addressCountry>\n        <phoneNumber>+61 3 0000 0000</phoneNumber>\n        <faxNumber>+61 3 0000 0001</faxNumber>\n        <addressEmail>john.smith@example.com</addressEmail>\n      </serviceContact>\n    </serviceProvider>\n    <fees>NONE</fees>\n    <accessConstraints>NONE</accessConstraints>\n  </serviceInformation>\n  <runtimeStatsEnabled>true</runtimeStatsEnabled>\n  <wmtsCiteCompliant>false</wmtsCiteCompliant>\n  <backendTimeout>120</backendTimeout>\n</global>";
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), "<global>\n  <serviceInformation>\n    <title>GeoWebCache</title>\n    <description>GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and\n      formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</description>\n    <keywords>\n      <string>WMS</string>\n      <string>WFS</string>\n      <string>WMTS</string>\n      <string>GEOWEBCACHE</string>\n    </keywords>\n    <serviceProvider>\n      <providerName>John Smith inc.</providerName>\n      <providerSite>http://www.example.com/</providerSite>\n      <serviceContact>\n        <individualName>John Smith</individualName>\n        <positionName>Geospatial Expert</positionName>\n        <addressType>Work</addressType>\n        <addressStreet>1 Bumpy St.</addressStreet>\n        <addressCity>Hobart</addressCity>\n        <addressAdministrativeArea>TAS</addressAdministrativeArea>\n        <addressPostalCode>7005</addressPostalCode>\n        <addressCountry>Australia</addressCountry>\n        <phoneNumber>+61 3 0000 0000</phoneNumber>\n        <faxNumber>+61 3 0000 0001</faxNumber>\n        <addressEmail>john.smith@example.com</addressEmail>\n      </serviceContact>\n    </serviceProvider>\n    <fees>NONE</fees>\n    <accessConstraints>NONE</accessConstraints>\n  </serviceInformation>\n  <runtimeStatsEnabled>true</runtimeStatsEnabled>\n  <wmtsCiteCompliant>false</wmtsCiteCompliant>\n  <backendTimeout>120</backendTimeout>\n</global>");){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    Matcher<Node> hasXPath(String xpathExpr, Matcher<String> matcher) {
        return Matchers.hasXPath((String)xpathExpr, (NamespaceContext)this.nsContext, matcher);
    }

    Matcher<Node> hasXPath(String xpathExpr) {
        return Matchers.hasXPath((String)xpathExpr, (NamespaceContext)this.nsContext);
    }

    @Test
    public void testGetLogo() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/web/geowebcache_logo.png"), this.anonymous.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testGetCss() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/web/gwc.css"), this.anonymous.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testGetBadWebResource() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/web/thisDoesNotExist"), this.anonymous.getClient());){
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testGetGlobal() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/title", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache")));
            Assert.assertThat((Object)doc, this.hasXPath("normalize-space(/global/serviceInformation/description)", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.")));
            Assert.assertThat((Object)doc, this.hasXPath("count(/global/serviceInformation/keywords/string)", (Matcher<String>)Matchers.equalTo((Object)"4")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/providerName", (Matcher<String>)Matchers.equalTo((Object)"John Smith inc.")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/serviceContact/individualName", (Matcher<String>)Matchers.equalTo((Object)"John Smith")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/runtimeStatsEnabled", (Matcher<String>)Matchers.equalTo((Object)"true")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/wmtsCiteCompliant", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/backendTimeout", (Matcher<String>)Matchers.equalTo((Object)"120")));
        }
    }

    @Test
    public void testPutGlobal() throws Exception {
        String globalUpdate = "<global>\n  <serviceInformation>\n    <title>GeoWebCache</title>\n    <description>GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and\n      formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</description>\n    <keywords>\n      <string>WMS</string>\n      <string>WMTS</string>\n      <string>GEOWEBCACHE</string>\n    </keywords>\n    <serviceProvider>\n      <providerName>Jane Doe inc.</providerName>\n      <providerSite>http://www.example.com/</providerSite>\n      <serviceContact>\n        <individualName>Jane Doe</individualName>\n        <positionName>Geospatial Expert</positionName>\n        <addressType>Work</addressType>\n        <addressStreet>1 Bumpy St.</addressStreet>\n        <addressCity>Hobart</addressCity>\n        <addressAdministrativeArea>TAS</addressAdministrativeArea>\n        <addressPostalCode>7005</addressPostalCode>\n        <addressCountry>Australia</addressCountry>\n        <phoneNumber>+61 3 0000 0000</phoneNumber>\n        <faxNumber>+61 3 0000 0001</faxNumber>\n        <addressEmail>jane.doe@example.com</addressEmail>\n      </serviceContact>\n    </serviceProvider>\n    <fees>NONE</fees>\n    <accessConstraints>NONE</accessConstraints>\n  </serviceInformation>\n  <runtimeStatsEnabled>false</runtimeStatsEnabled>\n  <wmtsCiteCompliant>false</wmtsCiteCompliant>\n  <backendTimeout>120</backendTimeout>\n</global>";
        this.testGetGlobal();
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), "<global>\n  <serviceInformation>\n    <title>GeoWebCache</title>\n    <description>GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and\n      formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</description>\n    <keywords>\n      <string>WMS</string>\n      <string>WMTS</string>\n      <string>GEOWEBCACHE</string>\n    </keywords>\n    <serviceProvider>\n      <providerName>Jane Doe inc.</providerName>\n      <providerSite>http://www.example.com/</providerSite>\n      <serviceContact>\n        <individualName>Jane Doe</individualName>\n        <positionName>Geospatial Expert</positionName>\n        <addressType>Work</addressType>\n        <addressStreet>1 Bumpy St.</addressStreet>\n        <addressCity>Hobart</addressCity>\n        <addressAdministrativeArea>TAS</addressAdministrativeArea>\n        <addressPostalCode>7005</addressPostalCode>\n        <addressCountry>Australia</addressCountry>\n        <phoneNumber>+61 3 0000 0000</phoneNumber>\n        <faxNumber>+61 3 0000 0001</faxNumber>\n        <addressEmail>jane.doe@example.com</addressEmail>\n      </serviceContact>\n    </serviceProvider>\n    <fees>NONE</fees>\n    <accessConstraints>NONE</accessConstraints>\n  </serviceInformation>\n  <runtimeStatsEnabled>false</runtimeStatsEnabled>\n  <wmtsCiteCompliant>false</wmtsCiteCompliant>\n  <backendTimeout>120</backendTimeout>\n</global>");){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/title", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache")));
            Assert.assertThat((Object)doc, this.hasXPath("normalize-space(/global/serviceInformation/description)", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.")));
            Assert.assertThat((Object)doc, this.hasXPath("count(/global/serviceInformation/keywords/string)", (Matcher<String>)Matchers.equalTo((Object)"3")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/providerName", (Matcher<String>)Matchers.equalTo((Object)"Jane Doe inc.")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/serviceContact/individualName", (Matcher<String>)Matchers.equalTo((Object)"Jane Doe")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/runtimeStatsEnabled", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/wmtsCiteCompliant", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/backendTimeout", (Matcher<String>)Matchers.equalTo((Object)"120")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testPutGlobalRoundTrip() throws Exception {
        String globalUpdate;
        this.testGetGlobal();
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            globalUpdate = this.getResponseEntity(response);
        }
        response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), globalUpdate);
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            response.close();
            this.testGetGlobal();
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testPutGlobalPartial() throws Exception {
        String globalUpdate = "<global><backendTimeout>150</backendTimeout></global>";
        this.testGetGlobal();
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), "<global><backendTimeout>150</backendTimeout></global>");){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/title", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache")));
            Assert.assertThat((Object)doc, this.hasXPath("normalize-space(/global/serviceInformation/description)", (Matcher<String>)Matchers.equalTo((Object)"GeoWebCache is an advanced tile cache for WMS servers. It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.")));
            Assert.assertThat((Object)doc, this.hasXPath("count(/global/serviceInformation/keywords/string)", (Matcher<String>)Matchers.equalTo((Object)"4")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/providerName", (Matcher<String>)Matchers.equalTo((Object)"John Smith inc.")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/serviceInformation/serviceProvider/serviceContact/individualName", (Matcher<String>)Matchers.equalTo((Object)"John Smith")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/runtimeStatsEnabled", (Matcher<String>)Matchers.equalTo((Object)"true")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/wmtsCiteCompliant", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("/global/backendTimeout", (Matcher<String>)Matchers.equalTo((Object)"150")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testPutGlobalLock() throws Exception {
        Document doc;
        String globalUpdate = "<global><lockProvider>nioLock</lockProvider></global>";
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("count(/global/lockProvider)", (Matcher<String>)Matchers.equalTo((Object)"0")));
        }
        response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), "<global><lockProvider>nioLock</lockProvider></global>");
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleGet(URI.create("/geowebcache/rest/global.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("/global/lockProvider", (Matcher<String>)Matchers.equalTo((Object)"nioLock")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testPutGlobalReadOnly() throws Exception {
        String globalUpdate = "<global><location>foobar</location></global>";
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/global"), this.admin.getClient(), "<global><location>foobar</location></global>");){
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testGetLayers() throws Exception {
        this.doGetXML("rest/layers.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> {
            Assert.assertThat((Object)doc, this.hasXPath("/layers/layer[name/text()='img states']/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)jetty.getUri().resolve("/geowebcache/rest/layers/img%20states.xml").toString())));
            Assert.assertThat((Object)doc, this.hasXPath("/layers/layer[name/text()='topp:states']/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)jetty.getUri().resolve("/geowebcache/rest/layers/topp:states.xml").toString())));
            Assert.assertThat((Object)doc, this.hasXPath("/layers/layer[name/text()='raster test layer']/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)jetty.getUri().resolve("/geowebcache/rest/layers/raster%20test%20layer.xml").toString())));
            Assert.assertThat((Object)doc, this.hasXPath("count(/layers/layer)", (Matcher<String>)Matchers.equalTo((Object)"3")));
        });
    }

    @Test
    public void testCreateUpdateDelete() throws Exception {
        String layerName = "testLayer";
        String url1 = "http://example.com/wms1?";
        String url2 = "http://example.com/wms2?";
        String layers = "remoteLayer";
        HttpPut request = new HttpPut(jetty.getUri().resolve("rest/layers/").resolve("testLayer.xml"));
        request.setEntity((HttpEntity)new StringEntity("<wmsLayer><name>testLayer</name><wmsUrl><string>http://example.com/wms1?</string></wmsUrl><wmsLayers>remoteLayer</wmsLayers></wmsLayer>", ContentType.APPLICATION_XML));
        try (CloseableHttpResponse response = this.admin.getClient().execute((HttpUriRequest)request);){
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)200)));
        }
        this.doGetXML("rest/layers.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> Assert.assertThat((Object)doc, this.hasXPath("/layers/layer[name/text()='testLayer']/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)jetty.getUri().resolve("/geowebcache/rest/layers/testLayer.xml").toString()))));
        this.doGetXML("rest/layers/testLayer.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> {
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/name", (Matcher<String>)Matchers.equalTo((Object)"testLayer")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsUrl/string", (Matcher<String>)Matchers.equalTo((Object)"http://example.com/wms1?")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsLayers", (Matcher<String>)Matchers.equalTo((Object)"remoteLayer")));
        });
        request = new HttpPost(jetty.getUri().resolve("rest/layers/").resolve("testLayer.xml"));
        request.setEntity((HttpEntity)new StringEntity("<wmsLayer><name>testLayer</name><wmsUrl><string>http://example.com/wms2?</string></wmsUrl><wmsLayers>remoteLayer</wmsLayers></wmsLayer>", ContentType.APPLICATION_XML));
        response = this.admin.getClient().execute((HttpUriRequest)request);
        try {
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)200)));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        this.doGetXML("rest/layers/testLayer.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> {
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/name", (Matcher<String>)Matchers.equalTo((Object)"testLayer")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsUrl/string", (Matcher<String>)Matchers.equalTo((Object)"http://example.com/wms2?")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsLayers", (Matcher<String>)Matchers.equalTo((Object)"remoteLayer")));
        });
        this.doGetXML("service/wmts?REQUEST=getcapabilities", this.anonymous.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> Assert.assertThat((Object)doc, this.hasXPath("/wmts:Capabilities/wmts:Contents/wmts:Layer/ows:Title[text()='testLayer']")));
        request = new HttpDelete(jetty.getUri().resolve("rest/layers/").resolve("testLayer.xml"));
        response = this.admin.getClient().execute((HttpUriRequest)request);
        try {
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)200)));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        this.doGetXML("rest/layers.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("/layers/layer[name/text()='testLayer']"))));
        HttpGet request2 = new HttpGet(jetty.getUri().resolve("rest/layers/").resolve("testLayer.xml"));
        try (CloseableHttpResponse response = this.admin.getClient().execute((HttpUriRequest)request2);){
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)404)));
        }
        this.doGetXML("service/wmts?REQUEST=getcapabilities", this.anonymous.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("/wmts:Capabilities/wmts:Contents/wmts:Layer/ows:Title[text()='testLayer']"))));
    }

    @Test
    public void testInvalidMethods() throws Exception {
        for (HttpUriRequest httpUriRequest : Arrays.asList(new HttpDelete(jetty.getUri().resolve("rest/layers.xml")), new HttpPost(jetty.getUri().resolve("rest/layers.xml")), new HttpPut(jetty.getUri().resolve("rest/layers.xml")), new HttpPut(jetty.getUri().resolve("rest/seed/img%20states.xml")), new HttpDelete(jetty.getUri().resolve("rest/seed/img%20states.xml")), new HttpDelete(jetty.getUri().resolve("rest/seed/ui_form")), new HttpPut(jetty.getUri().resolve("rest/seed/ui_form")), new HttpDelete(jetty.getUri().resolve("rest/diskquota.xml")), new HttpDelete(jetty.getUri().resolve("rest/diskquota.json")), new HttpDelete(jetty.getUri().resolve("rest/diskquota")), new HttpPut(jetty.getUri().resolve("rest/masstruncate")), new HttpDelete(jetty.getUri().resolve("rest/masstruncate")), new HttpPut(jetty.getUri().resolve("rest/statistics")), new HttpPost(jetty.getUri().resolve("rest/statistics")), new HttpDelete(jetty.getUri().resolve("rest/statistics")), new HttpPut(jetty.getUri().resolve("rest/reload")), new HttpGet(jetty.getUri().resolve("rest/reload")), new HttpDelete(jetty.getUri().resolve("rest/reload")))) {
            this.testSecured(httpUriRequest, (Matcher<Integer>)Matchers.equalTo((Object)405));
        }
    }

    @Test
    public void testSecure() throws Exception {
        for (HttpUriRequest httpUriRequest : Arrays.asList(new HttpGet(jetty.getUri().resolve("rest/layers.xml")), new HttpGet(jetty.getUri().resolve("rest/seed/img%20states")), new HttpPost(jetty.getUri().resolve("rest/reload")), new HttpPost(jetty.getUri().resolve("rest/seed/img%20states.xml")), new HttpGet(jetty.getUri().resolve("rest/seed/img%20states.xml")), new HttpGet(jetty.getUri().resolve("rest/seed/ui_form")), new HttpPost(jetty.getUri().resolve("rest/seed/ui_form")), new HttpGet(jetty.getUri().resolve("rest/masstruncate")), new HttpPost(jetty.getUri().resolve("rest/masstruncate")))) {
            this.testSecured(httpUriRequest, (Matcher<Integer>)Matchers.not((Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)401)).or(Matchers.equalTo((Object)405))));
        }
    }

    @Test
    public void testGetLayer() throws Exception {
        this.doGetXML("rest/layers/img%20states.xml", this.admin.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)200), (Document doc) -> {
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/name", (Matcher<String>)Matchers.equalTo((Object)"img states")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsUrl/string", (Matcher<String>)Matchers.equalTo((Object)"https://demo.boundlessgeo.com/geoserver/wms?")));
            Assert.assertThat((Object)doc, this.hasXPath("/wmsLayer/wmsLayers", (Matcher<String>)Matchers.equalTo((Object)"nurc:Img_Sample,topp:states")));
        });
    }

    @Test
    public void testLayerNoAuth() throws Exception {
        for (CloseableHttpClient client : Arrays.asList(this.anonymous.getClient(), this.notAUser.getClient())) {
            this.doGetXML("rest/layers/img%20states.xml", client, (Matcher<Integer>)Matchers.equalTo((Object)401), (Document doc) -> {
                Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsUrl", (Matcher<String>)Matchers.containsString((String)"demo.opengeo.org"))));
                Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"nurc"))));
                Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"Img_Sample"))));
                Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"topp"))));
                Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"states"))));
            });
        }
    }

    protected void testSecured(HttpUriRequest request, Matcher<Integer> authenticatedStatus) throws Exception {
        CloseableHttpClient client = this.admin.getClient();
        try (CloseableHttpResponse response = client.execute(request);
             InputStream in = response.getEntity().getContent();){
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", authenticatedStatus));
        }
        for (CloseableHttpClient client2 : Arrays.asList(this.anonymous.getClient(), this.notAUser.getClient(), this.badPassword.getClient())) {
            CloseableHttpResponse response = client2.execute(request);
            try {
                InputStream in = response.getEntity().getContent();
                try {
                    int code = 401;
                    Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.describedAs((String)"Request %0 with without authentication produces status code %1", (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)401)), (Object[])new Object[]{request, 401}));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
    }

    @Test
    public void testAddLayer() throws Exception {
        this.doGetXML("rest/layers/img%20states.xml", this.notAUser.getClient(), (Matcher<Integer>)Matchers.equalTo((Object)401), (Document doc) -> {
            Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsUrl", (Matcher<String>)Matchers.containsString((String)"demo.opengeo.org"))));
            Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"nurc"))));
            Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"Img_Sample"))));
            Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"topp"))));
            Assert.assertThat((Object)doc, (Matcher)Matchers.not(this.hasXPath("//wmsLayer", (Matcher<String>)Matchers.containsString((String)"states"))));
        });
    }

    @Test
    public void testGetBlobStoresXML() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("count(/blobStores/blobStore)", (Matcher<String>)Matchers.equalTo((Object)"1")));
            Assert.assertThat((Object)doc, this.hasXPath("/blobStores/blobStore[1]/name", (Matcher<String>)Matchers.equalTo((Object)"defaultCache")));
            Assert.assertThat((Object)doc, this.hasXPath("/blobStores/blobStore[1]/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)(String.valueOf(jetty.getUri()) + "rest/blobstores/defaultCache.xml"))));
            Assert.assertThat((Object)doc, this.hasXPath("/blobStores/blobStore[1]/atom:link/@type", (Matcher<String>)Matchers.equalTo((Object)"text/xml")));
        }
    }

    @Test
    public void testGetBlobStoresJSON() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            JSONArray jsonArray = this.getResponseEntityAsJSONArray(response);
            Assert.assertEquals((long)1L, (long)jsonArray.length());
            Assert.assertEquals((Object)"defaultCache", (Object)jsonArray.get(0));
        }
    }

    @Test
    public void testGetBlobStoreXML() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores/defaultCache.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//id", (Matcher<String>)Matchers.equalTo((Object)"defaultCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//enabled", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//baseDirectory", (Matcher<String>)Matchers.equalTo((Object)"/tmp/defaultCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//fileSystemBlockSize", (Matcher<String>)Matchers.equalTo((Object)"4096")));
        }
    }

    @Test
    public void testGetBlobStoreJSON() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores/defaultCache.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            JSONObject jsonObject = this.getResponseEntityAsJSONObject(response);
            jsonObject = jsonObject.getJSONObject("FileBlobStore");
            Assert.assertEquals((Object)"defaultCache", (Object)jsonObject.get("id"));
            Assert.assertEquals((Object)false, (Object)jsonObject.get("enabled"));
            Assert.assertEquals((Object)"/tmp/defaultCache", (Object)jsonObject.get("baseDirectory"));
            Assert.assertEquals((Object)4096, (Object)jsonObject.get("fileSystemBlockSize"));
        }
    }

    @Test
    public void testPutBlobStoreCreateModifyDelete() throws Exception {
        String blobStore = "<FileBlobStore>\n    <id>newCache</id>\n    <enabled>false</enabled>\n    <baseDirectory>/tmp/newCache</baseDirectory>\n    <fileSystemBlockSize>4096</fileSystemBlockSize>\n</FileBlobStore>";
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores/newCache.xml"), this.admin.getClient());){
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handlePut(URI.create("/geowebcache/rest/blobstores/newCache"), this.admin.getClient(), blobStore);
        try {
            Assert.assertEquals((long)201L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleGet(URI.create("/geowebcache/rest/blobstores/newCache.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//id", (Matcher<String>)Matchers.equalTo((Object)"newCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//enabled", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//baseDirectory", (Matcher<String>)Matchers.equalTo((Object)"/tmp/newCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//fileSystemBlockSize", (Matcher<String>)Matchers.equalTo((Object)"4096")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        String blobStoreUpdate = "<FileBlobStore>\n    <id>newCache</id>\n    <enabled>false</enabled>\n    <baseDirectory>/tmp/newCache</baseDirectory>\n    <fileSystemBlockSize>2048</fileSystemBlockSize>\n</FileBlobStore>";
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/blobstores/newCache"), this.admin.getClient(), blobStoreUpdate);){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handleGet(URI.create("/geowebcache/rest/blobstores/newCache.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//id", (Matcher<String>)Matchers.equalTo((Object)"newCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//enabled", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//baseDirectory", (Matcher<String>)Matchers.equalTo((Object)"/tmp/newCache")));
            Assert.assertThat((Object)doc, this.hasXPath("//fileSystemBlockSize", (Matcher<String>)Matchers.equalTo((Object)"2048")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleDelete(URI.create("/geowebcache/rest/blobstores/newCache.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleGet(URI.create("/geowebcache/rest/blobstores/newCache.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testGetGridSetsXML() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/gridsets.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("count(/gridSets/gridSet)", (Matcher<String>)Matchers.equalTo((Object)"143")));
            Assert.assertThat((Object)doc, this.hasXPath("/gridSets/gridSet[name = 'WebMercatorQuad']/name", (Matcher<String>)Matchers.equalTo((Object)"WebMercatorQuad")));
            Assert.assertThat((Object)doc, this.hasXPath("/gridSets/gridSet[name = 'WebMercatorQuad']/atom:link/@href", (Matcher<String>)Matchers.equalTo((Object)(String.valueOf(jetty.getUri()) + "rest/gridsets/WebMercatorQuad.xml"))));
            Assert.assertThat((Object)doc, this.hasXPath("/gridSets/gridSet[name = 'WebMercatorQuad']/atom:link/@type", (Matcher<String>)Matchers.equalTo((Object)"text/xml")));
        }
    }

    @Test
    public void testGetGridSetsJSON() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/gridsets.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            JSONArray jsonArray = this.getResponseEntityAsJSONArray(response);
            Assert.assertEquals((long)143L, (long)jsonArray.length());
            Assert.assertThat((Object)jsonArray, (Matcher)CoreMatchers.hasItem((Object)"WebMercatorQuad"));
        }
    }

    @Test
    public void testGetGridSetXML() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/gridsets/EPSG:2163.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//name", (Matcher<String>)Matchers.equalTo((Object)"EPSG:2163")));
            Assert.assertThat((Object)doc, this.hasXPath("//srs/number", (Matcher<String>)Matchers.equalTo((Object)"2163")));
            Assert.assertThat((Object)doc, this.hasXPath("//extent/coords/double[1]", (Matcher<String>)Matchers.equalTo((Object)"-2495667.977678598")));
            Assert.assertThat((Object)doc, this.hasXPath("//extent/coords/double[2]", (Matcher<String>)Matchers.equalTo((Object)"-2223677.196231552")));
            Assert.assertThat((Object)doc, this.hasXPath("//extent/coords/double[3]", (Matcher<String>)Matchers.equalTo((Object)"3291070.6104286816")));
            Assert.assertThat((Object)doc, this.hasXPath("//extent/coords/double[4]", (Matcher<String>)Matchers.equalTo((Object)"959189.3312465074")));
            Assert.assertThat((Object)doc, this.hasXPath("//scaleDenominators/double[1]", (Matcher<String>)Matchers.equalTo((Object)"2.5E7")));
            Assert.assertThat((Object)doc, this.hasXPath("//metersPerUnit", (Matcher<String>)Matchers.equalTo((Object)"1.0")));
            Assert.assertThat((Object)doc, this.hasXPath("//pixelSize", (Matcher<String>)Matchers.equalTo((Object)"2.8E-4")));
            Assert.assertThat((Object)doc, this.hasXPath("//yCoordinateFirst", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileWidth", (Matcher<String>)Matchers.equalTo((Object)"200")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileHeight", (Matcher<String>)Matchers.equalTo((Object)"200")));
        }
    }

    @Test
    public void testGetGridSetJSON() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/gridsets/EPSG:2163.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            JSONObject jsonObject = this.getResponseEntityAsJSONObject(response);
            jsonObject = jsonObject.getJSONObject("gridSet");
            Assert.assertEquals((Object)"EPSG:2163", (Object)jsonObject.get("name"));
            Assert.assertEquals((Object)2163, (Object)jsonObject.getJSONObject("srs").get("number"));
            Assert.assertEquals((Object)"[-2495667.977678598,-2223677.196231552,3291070.6104286816,959189.3312465074]", (Object)jsonObject.getJSONObject("extent").get("coords").toString());
            Assert.assertEquals((Object)"false", (Object)jsonObject.get("yCoordinateFirst").toString());
        }
    }

    @Test
    public void testPutGridSetCreateModifyDelete() throws Exception {
        String gridSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gridSet>\n  <name>testGridset</name>\n  <srs>\n    <number>4326</number>\n  </srs>\n  <extent>\n    <coords>\n      <double>-2495667.977678598</double>\n      <double>-2223677.196231552</double>\n      <double>3291070.6104286816</double>\n      <double>959189.3312465074</double>\n    </coords>\n  </extent>\n  <alignTopLeft>false</alignTopLeft>\n  <scaleDenominators>\n    <double>2.5E7</double>\n    <double>1000000.0</double>\n    <double>100000.0</double>\n    <double>25000.0</double>\n  </scaleDenominators>\n  <metersPerUnit>1.0</metersPerUnit>\n  <pixelSize>2.8E-4</pixelSize>\n  <scaleNames>\n    <string>EPSG:4326:0</string>\n    <string>EPSG:4326:1</string>\n    <string>EPSG:4326:2</string>\n    <string>EPSG:4326:3</string>\n  </scaleNames>\n  <tileHeight>211</tileHeight>\n  <tileWidth>211</tileWidth>\n  <yCoordinateFirst>false</yCoordinateFirst>\n</gridSet>";
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient());){
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handlePut(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient(), gridSet);
        try {
            Assert.assertEquals((long)201L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleGet(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//name", (Matcher<String>)Matchers.equalTo((Object)"testGridset")));
            Assert.assertThat((Object)doc, this.hasXPath("//srs/number", (Matcher<String>)Matchers.equalTo((Object)"4326")));
            Assert.assertThat((Object)doc, this.hasXPath("//scaleDenominators/double[1]", (Matcher<String>)Matchers.equalTo((Object)"2.5E7")));
            Assert.assertThat((Object)doc, this.hasXPath("//metersPerUnit", (Matcher<String>)Matchers.equalTo((Object)"1.0")));
            Assert.assertThat((Object)doc, this.hasXPath("//pixelSize", (Matcher<String>)Matchers.equalTo((Object)"2.8E-4")));
            Assert.assertThat((Object)doc, this.hasXPath("//yCoordinateFirst", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileWidth", (Matcher<String>)Matchers.equalTo((Object)"211")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileHeight", (Matcher<String>)Matchers.equalTo((Object)"211")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        String gridSetUpdate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gridSet>\n  <name>testGridset</name>\n  <srs>\n    <number>2163</number>\n  </srs>\n  <extent>\n    <coords>\n      <double>-2495667.977678598</double>\n      <double>-2223677.196231552</double>\n      <double>3291070.6104286816</double>\n      <double>959189.3312465074</double>\n    </coords>\n  </extent>\n  <alignTopLeft>false</alignTopLeft>\n  <scaleDenominators>\n    <double>2.5E7</double>\n    <double>1000000.0</double>\n    <double>100000.0</double>\n    <double>25000.0</double>\n  </scaleDenominators>\n  <metersPerUnit>1.0</metersPerUnit>\n  <pixelSize>2.8E-4</pixelSize>\n  <scaleNames>\n    <string>EPSG:2163:0</string>\n    <string>EPSG:2163:1</string>\n    <string>EPSG:2163:2</string>\n    <string>EPSG:2163:3</string>\n  </scaleNames>\n  <tileHeight>200</tileHeight>\n  <tileWidth>200</tileWidth>\n  <yCoordinateFirst>false</yCoordinateFirst>\n</gridSet>";
        try (CloseableHttpResponse response = this.handlePut(URI.create("/geowebcache/rest/gridsets/testGridset"), this.admin.getClient(), gridSetUpdate);){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        response = this.handleGet(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Document doc = this.getResponseEntityAsXML(response);
            Assert.assertThat((Object)doc, this.hasXPath("//name", (Matcher<String>)Matchers.equalTo((Object)"testGridset")));
            Assert.assertThat((Object)doc, this.hasXPath("//srs/number", (Matcher<String>)Matchers.equalTo((Object)"2163")));
            Assert.assertThat((Object)doc, this.hasXPath("//scaleDenominators/double[1]", (Matcher<String>)Matchers.equalTo((Object)"2.5E7")));
            Assert.assertThat((Object)doc, this.hasXPath("//metersPerUnit", (Matcher<String>)Matchers.equalTo((Object)"1.0")));
            Assert.assertThat((Object)doc, this.hasXPath("//pixelSize", (Matcher<String>)Matchers.equalTo((Object)"2.8E-4")));
            Assert.assertThat((Object)doc, this.hasXPath("//yCoordinateFirst", (Matcher<String>)Matchers.equalTo((Object)"false")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileWidth", (Matcher<String>)Matchers.equalTo((Object)"200")));
            Assert.assertThat((Object)doc, this.hasXPath("//tileHeight", (Matcher<String>)Matchers.equalTo((Object)"200")));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleDelete(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.handleGet(URI.create("/geowebcache/rest/gridsets/testGridset.xml"), this.admin.getClient());
        try {
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testDiskQuotaXML() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/diskquota.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200) {
                Document doc = this.getResponseEntityAsXML(response);
                Assert.assertThat((Object)doc, this.hasXPath("//enabled", (Matcher<String>)Matchers.equalTo((Object)"false")));
                Assert.assertThat((Object)doc, this.hasXPath("//cacheCleanUpFrequency", (Matcher<String>)Matchers.equalTo((Object)"10")));
                Assert.assertThat((Object)doc, this.hasXPath("//cacheCleanUpUnits", (Matcher<String>)Matchers.equalTo((Object)"SECONDS")));
                Assert.assertThat((Object)doc, this.hasXPath("//maxConcurrentCleanUps", (Matcher<String>)Matchers.equalTo((Object)"2")));
                Assert.assertThat((Object)doc, this.hasXPath("//globalExpirationPolicyName", (Matcher<String>)Matchers.equalTo((Object)"LFU")));
                Assert.assertThat((Object)doc, this.hasXPath("//globalQuota/id", (Matcher<String>)Matchers.equalTo((Object)"0")));
                Assert.assertThat((Object)doc, this.hasXPath("//globalQuota/bytes", (Matcher<String>)Matchers.equalTo((Object)"524288000")));
            }
        }
    }

    @Test
    public void testDiskQuotaJson() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/diskquota.json"), this.admin.getClient());){
            JSONObject jsonObject;
            Object obj;
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && (obj = (jsonObject = this.getResponseEntityAsJSONObject(response)).get("org.geowebcache.diskquota.DiskQuotaConfig")) instanceof JSONObject) {
                Assert.assertEquals((Object)false, (Object)((JSONObject)obj).get("enabled"));
                Assert.assertEquals((Object)10, (Object)((JSONObject)obj).get("cacheCleanUpFrequency"));
                Assert.assertEquals((Object)"SECONDS", (Object)((JSONObject)obj).get("cacheCleanUpUnits"));
                Assert.assertEquals((Object)2, (Object)((JSONObject)obj).get("maxConcurrentCleanUps"));
                Assert.assertEquals((Object)"LFU", (Object)((JSONObject)obj).get("globalExpirationPolicyName"));
                Object globalQuota = ((JSONObject)obj).get("globalQuota");
                if (globalQuota instanceof JSONObject) {
                    Assert.assertEquals((Object)0, (Object)((JSONObject)globalQuota).get("id"));
                    Assert.assertEquals((Object)524288000, (Object)((JSONObject)globalQuota).get("bytes"));
                }
            }
        }
    }

    @Test
    public void testSeedPost() throws Exception {
        String seedLayer = "<seedRequest>  <name>topp:states</name>  <srs>    <number>4326</number>  </srs>  <zoomStart>1</zoomStart>  <zoomStop>12</zoomStop>  <format>image/png</format>  <type>truncate</type>  <threadCount>4</threadCount></seedRequest>";
        try (CloseableHttpResponse response = this.handlePost(URI.create("/geowebcache/rest/seed/topp:states.xml"), this.admin.getClient(), seedLayer);){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGet() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed/topp:states"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGetNoLayer() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed"), this.admin.getClient());){
            Assert.assertEquals((long)405L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGetSeedForm() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed/topp:states"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGetJson() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGetLayerJson() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed/topp:states.json"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSeedGetLayerXml() throws Exception {
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/seed/topp:states.xml"), this.admin.getClient());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testKillAll() throws Exception {
        String killCommand = "kill_all=all";
        try (CloseableHttpResponse response = this.handlePost(URI.create("/geowebcache/rest/seed"), this.admin.getClient(), killCommand);){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testLayerKillAll() throws Exception {
        String killCommand = "kill_all=all";
        try (CloseableHttpResponse response = this.handlePost(URI.create("/geowebcache/rest/seed/topp:states"), this.admin.getClient(), killCommand);){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testNewFileBlobstoreDontDeleteExistingContent() throws Exception {
        File bsDir = temp.newFolder();
        File existingFile1 = new File(bsDir, "existingFile1");
        existingFile1.createNewFile();
        File existingDirectory = new File(bsDir, "existingDirectory");
        existingDirectory.mkdir();
        File existingFile2 = new File(existingDirectory, "existingFile2");
        existingFile2.createNewFile();
        String blobStore = "<FileBlobStore>\n    <id>maliciousCache</id>\n    <enabled>true</enabled>\n    <baseDirectory>" + String.valueOf(bsDir) + "</baseDirectory>\n    <fileSystemBlockSize>4096</fileSystemBlockSize>\n</FileBlobStore>";
        String layer1name = existingFile1.getName();
        String layer1 = "<wmsLayer>\n    <name>" + layer1name + "</name>\n    <blobStoreId>maliciousCache</blobStoreId>\n    <wmsUrl><string>http://example.com/geoserver/wms</string></wmsUrl>\n</wmsLayer>";
        String layer1truncate = "<truncateLayer><layerName>" + layer1name + "</layerName></truncateLayer>";
        String layer2name = existingDirectory.getName();
        String layer2 = "<wmsLayer>\n    <name>" + layer2name + "</name>\n    <blobStoreId>maliciousCache</blobStoreId>\n    <wmsUrl><string>http://example.com/geoserver/wms</string></wmsUrl>\n</wmsLayer>";
        String layer2truncate = "<truncateLayer><layerName>" + layer2name + "</layerName></truncateLayer>";
        try (CloseableHttpResponse response = this.handleGet(URI.create("/geowebcache/rest/blobstores/maliciousCache.xml"), this.admin.getClient());){
            Assert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"statusLine", (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)404))));
        }
        try {
            response = this.handlePut(URI.create("/geowebcache/rest/blobstores/maliciousCache"), this.admin.getClient(), blobStore);
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response2) {
            // empty catch block
        }
        try {
            response = this.handlePut(URI.create("/geowebcache/rest/layers/" + layer1name), this.admin.getClient(), layer1);
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response3) {
            // empty catch block
        }
        try {
            response = this.handlePut(URI.create("/geowebcache/rest/layers/" + layer2name), this.admin.getClient(), layer2);
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response4) {
            // empty catch block
        }
        response = this.handlePost(URI.create("/geowebcache/rest/masstruncate"), this.admin.getClient(), layer1truncate);
        if (response != null) {
            response.close();
        }
        try {
            response = this.handlePost(URI.create("/geowebcache/rest/masstruncate"), this.admin.getClient(), layer2truncate);
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response5) {
            // empty catch block
        }
        try {
            response = this.handleDelete(URI.create("/geowebcache/rest/layers/" + layer1name), this.admin.getClient());
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response6) {
            // empty catch block
        }
        try {
            response = this.handleDelete(URI.create("/geowebcache/rest/layers/" + layer2name), this.admin.getClient());
            if (response != null) {
                response.close();
            }
        }
        catch (Exception response7) {
            // empty catch block
        }
        try {
            response = this.handleDelete(URI.create("/geowebcache/rest/blobstores/maliciousCache"), this.admin.getClient());
            if (response != null) {
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertThat((Object)existingFile1, (Matcher)FileMatchers.exists());
        Assert.assertThat((Object)existingDirectory, (Matcher)FileMatchers.exists());
        Assert.assertThat((Object)existingFile2, (Matcher)FileMatchers.exists());
    }

    private Document getResponseEntityAsXML(CloseableHttpResponse response) throws Exception {
        Document doc = XMLUnit.buildTestDocument((InputSource)new InputSource(response.getEntity().getContent()));
        doc.normalizeDocument();
        return doc;
    }

    private JSONObject getResponseEntityAsJSONObject(CloseableHttpResponse response) throws Exception {
        JSONObject jsonObject = new JSONObject(this.getResponseEntity(response));
        return jsonObject;
    }

    private JSONArray getResponseEntityAsJSONArray(CloseableHttpResponse response) throws Exception {
        JSONArray jsonObject = new JSONArray(this.getResponseEntity(response));
        return jsonObject;
    }

    private String getResponseEntity(CloseableHttpResponse response) {
        String doc;
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)response.getEntity().getContent(), (Writer)writer, (Charset)Charset.defaultCharset());
            doc = writer.toString();
        }
        catch (IOException e) {
            doc = e.getMessage().toString();
        }
        return doc;
    }

    private CloseableHttpResponse handleGet(URI uri, CloseableHttpClient client) throws Exception {
        HttpGet request = new HttpGet(jetty.getUri().resolve(uri));
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return response;
    }

    void doGetXML(String uri, CloseableHttpClient client, Matcher<Integer> statusMatcher, Assertions<Document> body) throws Exception {
        this.doGetXML(URI.create(uri), client, statusMatcher, body);
    }

    void doGetXML(URI uri, CloseableHttpClient client, Matcher<Integer> statusMatcher, Assertions<Document> body) throws Exception {
        HttpGet request = new HttpGet(jetty.getUri().resolve(uri));
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);
             InputStream in = response.getEntity().getContent();){
            if (response.getStatusLine().getStatusCode() != 401) {
                Document doc = XMLUnit.buildTestDocument((InputSource)new InputSource(in));
                body.accept(doc);
            }
            Assert.assertThat((Object)response.getStatusLine(), (Matcher)Matchers.hasProperty((String)"statusCode", statusMatcher));
        }
    }

    private CloseableHttpResponse handleDelete(URI uri, CloseableHttpClient client) throws Exception {
        HttpDelete request = new HttpDelete(jetty.getUri().resolve(uri));
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return response;
    }

    private CloseableHttpResponse handlePut(URI uri, CloseableHttpClient client, String data) throws Exception {
        HttpPut request = new HttpPut(jetty.getUri().resolve(uri));
        StringEntity entity = new StringEntity(data);
        entity.setContentType((Header)new BasicHeader("Content-type", "text/xml"));
        request.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return response;
    }

    private CloseableHttpResponse handlePost(URI uri, CloseableHttpClient client, String data) throws Exception {
        HttpPost request = new HttpPost(jetty.getUri().resolve(uri));
        StringEntity entity = new StringEntity(data);
        entity.setContentType((Header)new BasicHeader("Content-type", "text/xml"));
        request.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return response;
    }

    static interface Assertions<T> {
        public void accept(T var1) throws Exception;
    }
}

