/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.jetty;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.geotools.util.logging.Logging;

public class Start {
    private static final Logger log = Logging.getLogger((String)Start.class.getName());

    public static void main(String[] args) {
        block4: {
            final Server jettyServer = new Server();
            try {
                HttpConfiguration httpConfiguration = new HttpConfiguration();
                ServerConnector http = new ServerConnector(jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
                http.setPort(Integer.getInteger("jetty.port", 8080).intValue());
                http.setAcceptQueueSize(100);
                http.setIdleTimeout(3600000L);
                jettyServer.setConnectors(new Connector[]{http});
                WebAppContext wah = new WebAppContext();
                wah.setContextPath("/geowebcache");
                wah.setWar("src/main/webapp");
                jettyServer.setHandler((Handler)wah);
                wah.setTempDirectory(new File("target/work"));
                jettyServer.setHandler((Handler)wah);
                jettyServer.start();
                jettyServer.join();
                Thread stopThread = new Thread(){

                    @Override
                    public void run() {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                        try {
                            while (true) {
                                String line;
                                if (!"stop".equals(line = reader.readLine())) {
                                    continue;
                                }
                                jettyServer.stop();
                                System.exit(0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                            return;
                        }
                    }
                };
                stopThread.setDaemon(true);
                stopThread.run();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not start the Jetty server: " + e.getMessage(), e);
                if (jettyServer == null) break block4;
                try {
                    jettyServer.stop();
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Unable to stop the Jetty server:" + e1.getMessage(), e1);
                }
            }
        }
    }
}

