/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.wms;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.geotools.data.ows.OperationType;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSRequest;
import org.geotools.ows.wms.WebMapServer;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.legends.LegendRawInfo;
import org.geowebcache.config.wms.GetCapabilitiesConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetCapabilitiesConfigurationTest {
    WebMapServer server;
    WMSCapabilities cap;
    WMSRequest req;
    OperationType gcOpType;
    DefaultingConfiguration globalConfig;
    Capture<TileLayer> layerCapture;
    GridSetBroker broker;

    @Before
    public void setUp() throws Exception {
        this.server = (WebMapServer)EasyMock.createNiceMock(WebMapServer.class);
        this.cap = (WMSCapabilities)EasyMock.createNiceMock(WMSCapabilities.class);
        this.req = (WMSRequest)EasyMock.createNiceMock(WMSRequest.class);
        this.gcOpType = (OperationType)EasyMock.createNiceMock(OperationType.class);
        this.globalConfig = (DefaultingConfiguration)EasyMock.createNiceMock(DefaultingConfiguration.class);
        this.layerCapture = EasyMock.newCapture((CaptureType)CaptureType.LAST);
        this.broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        EasyMock.expect((Object)this.server.getCapabilities()).andStubReturn((Object)this.cap);
        EasyMock.expect((Object)this.cap.getRequest()).andStubReturn((Object)this.req);
        EasyMock.expect((Object)this.req.getGetCapabilities()).andStubReturn((Object)this.gcOpType);
        EasyMock.expect((Object)this.gcOpType.getGet()).andStubReturn((Object)new URL("http://test/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities"));
        EasyMock.expect((Object)this.cap.getVersion()).andStubReturn((Object)"1.1.1");
    }

    @Test
    public void testNullParameterFilters() throws Exception {
        Layer l = new Layer();
        l.setName("Foo");
        l.setLatLonBoundingBox(new CRSEnvelope());
        LinkedList<Layer> layers = new LinkedList<Layer>();
        layers.add(l);
        EasyMock.expect((Object)this.cap.getLayerList()).andReturn(layers);
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(this.broker, "http://test/wms", "image/png", "3x3", "", null, "false"){

            WebMapServer getWMS() {
                return GetCapabilitiesConfigurationTest.this.server;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.server, this.cap, this.req, this.gcOpType, this.globalConfig});
        config.setPrimaryConfig(this.globalConfig);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        WMSLayer wmsLayer = (WMSLayer)config.getLayers().iterator().next();
        List outputParameterFilters = wmsLayer.getParameterFilters();
        Assert.assertThat((Object)outputParameterFilters, (Matcher)Matchers.contains((Matcher)HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"styles"))));
    }

    @Test
    public void testEmptyParameterFilters() throws Exception {
        Layer l = new Layer();
        l.setName("Foo");
        l.setLatLonBoundingBox(new CRSEnvelope());
        LinkedList<Layer> layers = new LinkedList<Layer>();
        layers.add(l);
        EasyMock.expect((Object)this.cap.getLayerList()).andReturn(layers);
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(this.broker, "http://test/wms", "image/png", "3x3", "", new HashMap(), "false"){

            WebMapServer getWMS() {
                return GetCapabilitiesConfigurationTest.this.server;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.server, this.cap, this.req, this.gcOpType, this.globalConfig});
        config.setPrimaryConfig(this.globalConfig);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        WMSLayer wmsLayer = (WMSLayer)config.getLayers().iterator().next();
        List outputParameterFilters = wmsLayer.getParameterFilters();
        Assert.assertThat((Object)outputParameterFilters, (Matcher)Matchers.contains((Matcher)HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"styles"))));
    }

    @Test
    public void testBlankParameterFilters() throws Exception {
        Layer l = new Layer();
        l.setName("Foo");
        l.setLatLonBoundingBox(new CRSEnvelope());
        LinkedList<Layer> layers = new LinkedList<Layer>();
        layers.add(l);
        EasyMock.expect((Object)this.cap.getLayerList()).andReturn(layers);
        HashMap<String, String> cachedParams = new HashMap<String, String>();
        cachedParams.put("", "");
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(this.broker, "http://test/wms", "image/png", "3x3", "", cachedParams, "false"){

            WebMapServer getWMS() {
                return GetCapabilitiesConfigurationTest.this.server;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.server, this.cap, this.req, this.gcOpType, this.globalConfig});
        config.setPrimaryConfig(this.globalConfig);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        WMSLayer wmsLayer = (WMSLayer)config.getLayers().iterator().next();
        List outputParameterFilters = wmsLayer.getParameterFilters();
        Assert.assertThat((Object)outputParameterFilters, (Matcher)Matchers.contains((Matcher)HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"styles"))));
    }

    @Test
    public void testDelegateInitializingLayers() throws Exception {
        GridSetBroker broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        String url = "http://test/wms";
        String mimeTypes = "image/png";
        String vendorParameters = "map=/osgeo/mapserver/msautotest/world/world.map";
        HashMap<String, String> cachedParams = new HashMap<String, String>();
        cachedParams.put("angle", "");
        cachedParams.put("CQL_FILTER", "1=1");
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(broker, url, mimeTypes, "3x3", vendorParameters, cachedParams, "false"){

            WebMapServer getWMS() {
                return GetCapabilitiesConfigurationTest.this.server;
            }
        };
        EasyMock.expect((Object)this.server.getCapabilities()).andStubReturn((Object)this.cap);
        EasyMock.expect((Object)this.cap.getRequest()).andStubReturn((Object)this.req);
        EasyMock.expect((Object)this.req.getGetCapabilities()).andStubReturn((Object)this.gcOpType);
        EasyMock.expect((Object)this.gcOpType.getGet()).andStubReturn((Object)new URL("http://test/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities"));
        EasyMock.expect((Object)this.cap.getVersion()).andStubReturn((Object)"1.1.1");
        LinkedList<Layer> layers = new LinkedList<Layer>();
        Layer l = new Layer();
        l.setName("Foo");
        l.setLatLonBoundingBox(new CRSEnvelope());
        StyleImpl style = new StyleImpl();
        style.setName("style1");
        style.setLegendURLs(Collections.singletonList("http://localhost:8080/geoserver/topp/wms?service=WMS&request=GetLegendGraphic&format=image/gif&width=50&height=100&layer=topp:states&style=polygon"));
        l.setStyles(Collections.singletonList(style));
        layers.add(l);
        this.globalConfig.setDefaultValues((TileLayer)EasyMock.capture(this.layerCapture));
        EasyMock.expectLastCall().times(layers.size());
        EasyMock.expect((Object)this.cap.getLayerList()).andReturn(layers);
        EasyMock.replay((Object[])new Object[]{this.server, this.cap, this.req, this.gcOpType, this.globalConfig});
        config.setPrimaryConfig(this.globalConfig);
        config.setGridSetBroker(broker);
        config.afterPropertiesSet();
        Assert.assertThat((Object)Sets.newHashSet((Iterable)config.getLayers()), (Matcher)Matchers.is((Object)Sets.newHashSet((Iterable)this.layerCapture.getValues())));
        EasyMock.verify((Object[])new Object[]{this.server, this.cap, this.req, this.gcOpType, this.globalConfig});
        WMSLayer wmsLayer = (WMSLayer)config.getLayer("Foo").get();
        Assert.assertThat((Object)wmsLayer, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)wmsLayer.getLegends(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)wmsLayer.getLegends().getDefaultWidth(), (Matcher)Matchers.is((Object)20));
        Assert.assertThat((Object)wmsLayer.getLegends().getDefaultHeight(), (Matcher)Matchers.is((Object)20));
        Assert.assertThat((Object)wmsLayer.getLegends().getDefaultFormat(), (Matcher)Matchers.is((Object)"image/png"));
        Assert.assertThat((Object)wmsLayer.getLegends().getLegendsRawInfo(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)wmsLayer.getLegends().getLegendsRawInfo().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((LegendRawInfo)wmsLayer.getLegends().getLegendsRawInfo().get(0)).getWidth(), (Matcher)Matchers.is((Object)50));
        Assert.assertThat((Object)((LegendRawInfo)wmsLayer.getLegends().getLegendsRawInfo().get(0)).getHeight(), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)((LegendRawInfo)wmsLayer.getLegends().getLegendsRawInfo().get(0)).getFormat(), (Matcher)Matchers.is((Object)"image/gif"));
        List outputParameterFilters = wmsLayer.getParameterFilters();
        Assert.assertThat((Object)outputParameterFilters, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"styles")), HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"CQL_FILTER")), HasPropertyWithValue.hasProperty((String)"key", (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"angle"))}));
    }
}

