/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.wms;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.easymock.EasyMock;
import org.geotools.data.ows.OperationType;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSRequest;
import org.geotools.ows.wms.WebMapServer;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.GridSetConfigurationTest;
import org.geowebcache.config.wms.GetCapabilitiesConfiguration;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.util.TestUtils;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class GetCapabilitiesGridSetConfigurationConformanceTest
extends GridSetConfigurationTest {
    private GridSetBroker broker;

    @Before
    public void setupBroker() {
        if (this.broker == null) {
            this.broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        }
    }

    protected void doModifyInfo(GridSet info, int rand) throws Exception {
        info.setDescription(Integer.toString(rand));
    }

    protected String getExistingInfo() {
        return "testExisting:EPSG:3978";
    }

    protected GridSetConfiguration getConfig() throws Exception {
        final WebMapServer server = (WebMapServer)EasyMock.createNiceMock(WebMapServer.class);
        WMSCapabilities cap = (WMSCapabilities)EasyMock.createNiceMock(WMSCapabilities.class);
        WMSRequest req = (WMSRequest)EasyMock.createNiceMock(WMSRequest.class);
        OperationType gcOpType = (OperationType)EasyMock.createNiceMock(OperationType.class);
        DefaultingConfiguration globalConfig = (DefaultingConfiguration)EasyMock.createNiceMock(DefaultingConfiguration.class);
        this.setupBroker();
        Layer l = new Layer();
        l.setName("testExisting");
        l.setBoundingBoxes(new CRSEnvelope("EPSG:3978", -2259049.0, 347711.0, -1994160.0, 827919.0));
        l.setLatLonBoundingBox(new CRSEnvelope());
        LinkedList<Layer> layers = new LinkedList<Layer>();
        layers.add(l);
        EasyMock.expect((Object)cap.getLayerList()).andReturn(layers);
        EasyMock.expect((Object)server.getCapabilities()).andStubReturn((Object)cap);
        EasyMock.expect((Object)cap.getRequest()).andStubReturn((Object)req);
        EasyMock.expect((Object)req.getGetCapabilities()).andStubReturn((Object)gcOpType);
        EasyMock.expect((Object)gcOpType.getGet()).andStubReturn((Object)new URL("http://test/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities"));
        EasyMock.expect((Object)cap.getVersion()).andStubReturn((Object)"1.1.1");
        EasyMock.replay((Object[])new Object[]{server, cap, req, gcOpType, globalConfig});
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(this.broker, "http://test/wms", "image/png", "3x3", "", null, "false"){

            WebMapServer getWMS() {
                return server;
            }
        };
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        return config;
    }

    protected GridSetConfiguration getSecondConfig() throws Exception {
        Assume.assumeTrue((String)"This configuration does not have persistance", (boolean)false);
        return null;
    }

    @Test
    public void testLayerGridsets() throws Exception {
        TileLayer layer = (TileLayer)TestUtils.requirePresent((Optional)((GetCapabilitiesConfiguration)this.config).getLayer("testExisting"));
        GridSet gridset = (GridSet)TestUtils.assertPresent((Optional)((GridSetConfiguration)this.config).getGridSet("testExisting:EPSG:3978"));
        GridSubset gridSubset = layer.getGridSubset("testExisting:EPSG:3978");
        GridSet gridSet2 = gridSubset.getGridSet();
        Assert.assertThat((Object)gridSet2, (Matcher)Matchers.equalTo((Object)gridset));
    }

    protected Matcher<GridSet> infoEquals(final GridSet expected) {
        return new CustomMatcher<GridSet>("GridSet matching " + expected.getName() + " with " + expected.getDescription()){

            public boolean matches(Object item) {
                return item instanceof GridSet && ((GridSet)item).getName().equals(expected.getName()) && ((GridSet)item).getDescription().equals(expected.getDescription());
            }
        };
    }

    protected Matcher<GridSet> infoEquals(final int expected) {
        return new CustomMatcher<GridSet>("GridSet with value " + expected){

            public boolean matches(Object item) {
                return item instanceof GridSet && Objects.equal((Object)((GridSet)item).getDescription(), (Object)Integer.toString(expected));
            }
        };
    }

    public void failNextRead() {
        Assume.assumeFalse((boolean)true);
    }

    public void failNextWrite() {
        Assume.assumeFalse((boolean)true);
    }

    protected void renameInfo(GridSetConfiguration config, String name1, String name2) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void addInfo(GridSetConfiguration config, GridSet info) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void removeInfo(GridSetConfiguration config, String name) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void modifyInfo(GridSetConfiguration config, GridSet info) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    @Test
    public void testCanSaveGoodInfo() throws Exception {
        Assert.assertThat((Object)((GridSetConfiguration)this.config).canSave(this.getGoodInfo("test", 1)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    @Ignore
    public void testAddBadInfoException() throws Exception {
        super.testAddBadInfoException();
    }

    @Test
    @Ignore
    public void testRemoveNotExists() throws Exception {
        super.testRemoveNotExists();
    }

    @Test
    @Ignore
    public void testModifyNotExistsExcpetion() throws Exception {
        super.testModifyNotExistsExcpetion();
    }
}

