/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.easymock.EasyMock;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.legends.LegendRawInfo;
import org.geowebcache.config.legends.LegendsRawInfo;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.service.wms.WMSGetCapabilities;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.URLMangler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.xml.HasXPath;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WMSGetCapabilitiesTest {
    @Test
    public void testEscapeXMLChars() throws Exception {
        TileLayerDispatcher tld = (TileLayerDispatcher)EasyMock.createMock(TileLayerDispatcher.class);
        HttpServletRequest servReq = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        String baseUrl = "http://example.com/geowebcache/";
        String contextPath = "service/";
        NullURLMangler urlMangler = new NullURLMangler();
        ServiceInformation servInfo = (ServiceInformation)EasyMock.createMock(ServiceInformation.class);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("SERVICE", new String[]{"WMS"});
        parameterMap.put("VERSION", new String[]{"1.1.1"});
        parameterMap.put("REQUEST", new String[]{"getcapabilities"});
        parameterMap.put("TILED", new String[]{"true"});
        EasyMock.expect((Object)servReq.getParameterMap()).andStubReturn(Collections.unmodifiableMap(parameterMap));
        EasyMock.expect((Object)servReq.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        EasyMock.expect((Object)servInfo.getTitle()).andStubReturn((Object)"Title & \"stuff\"");
        EasyMock.expect((Object)servInfo.getDescription()).andStubReturn((Object)"This \"description\" contains <characters> which & should be 'escaped'.");
        EasyMock.expect((Object)servInfo.getKeywords()).andStubReturn(null);
        EasyMock.expect((Object)servInfo.getServiceProvider()).andStubReturn(null);
        EasyMock.expect((Object)servInfo.getFees()).andStubReturn((Object)"NONE");
        EasyMock.expect((Object)servInfo.getAccessConstraints()).andStubReturn((Object)"NONE");
        EasyMock.expect((Object)tld.getServiceInformation()).andStubReturn((Object)servInfo);
        StringParameterFilter stylesParameterFilter = new StringParameterFilter();
        stylesParameterFilter.setKey("STYLES");
        stylesParameterFilter.setValues(Arrays.asList("style1", "style2"));
        HashMap<String, GridSubset> subSets = new HashMap<String, GridSubset>();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true))).get("EPSG:4326"));
        subSets.put(gridSubSet.getName(), gridSubSet);
        WMSLayer advertisedLayer = new WMSLayer("testAdv", null, "style,style2", null, null, subSets, Collections.singletonList(stylesParameterFilter), null, null, false, null);
        advertisedLayer.setEnabled(true);
        advertisedLayer.setAdvertised(true);
        LegendsRawInfo legendsRawInfo = new LegendsRawInfo();
        legendsRawInfo.setDefaultWidth(Integer.valueOf(50));
        legendsRawInfo.setDefaultHeight(Integer.valueOf(100));
        legendsRawInfo.setDefaultFormat("image/png");
        LegendRawInfo legendRawInfo1 = new LegendRawInfo();
        legendRawInfo1.setStyle("style1");
        legendRawInfo1.setUrl("htp://localhost:8080/geoserver");
        LegendRawInfo legendRawInfo2 = new LegendRawInfo();
        legendRawInfo2.setStyle("style2");
        legendRawInfo2.setUrl("htp://localhost:8080/geoserver");
        legendsRawInfo.addLegendRawInfo(legendRawInfo1);
        legendsRawInfo.addLegendRawInfo(legendRawInfo2);
        advertisedLayer.setLegends(legendsRawInfo);
        WMSLayer unAdvertisedLayer = new WMSLayer("testNotAdv", null, null, null, null, subSets, null, null, null, false, null);
        unAdvertisedLayer.setEnabled(true);
        unAdvertisedLayer.setAdvertised(false);
        EasyMock.expect((Object)tld.getLayerList()).andStubReturn(Arrays.asList(advertisedLayer, unAdvertisedLayer));
        EasyMock.expect((Object)tld.getLayerListFiltered()).andStubReturn(Arrays.asList(advertisedLayer, unAdvertisedLayer));
        EasyMock.replay((Object[])new Object[]{tld, servReq, response, servInfo});
        WMSGetCapabilities capabilities = new WMSGetCapabilities(tld, servReq, baseUrl, contextPath, (URLMangler)urlMangler);
        String xml = capabilities.generateGetCapabilities(StandardCharsets.UTF_8);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document document = builder.parse(is);
        Assert.assertThat((Object)document.getDocumentElement(), (Matcher)HasXPath.hasXPath((String)"/WMT_MS_Capabilities/Service/Title[text()='Title & \"stuff\"']"));
        Assert.assertThat((Object)document.getDocumentElement(), (Matcher)HasXPath.hasXPath((String)("/WMT_MS_Capabilities/Service/Abstract[text()=" + this.xpathString("This \"description\" contains <characters> which & should be 'escaped'.") + "]")));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"& ")));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<characters>")));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"'escaped'")));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"description\"")));
        Assert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"testAdv"));
        Assert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testNotAdv")));
        Assert.assertThat((Object)document.getDocumentElement(), (Matcher)HasXPath.hasXPath((String)"/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet[Layers='testAdv']/Styles[not(Style/Name)]"));
        Assert.assertThat((Object)document.getDocumentElement(), (Matcher)HasXPath.hasXPath((String)"/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet/Styles/Style[Name='style1']/LegendURL[@width='50'][@height='100'][Format='image/png']/OnlineResource[@type='simple'][@href='htp://localhost:8080/geoserver?service=WMS&request=GetLegendGraphic&format=image/png&width=50&height=100&layer=testAdv&style=style1']"));
        Assert.assertThat((Object)document.getDocumentElement(), (Matcher)HasXPath.hasXPath((String)"/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet/Styles/Style[Name='style2']/LegendURL[@width='50'][@height='100'][Format='image/png']/OnlineResource[@type='simple'][@href='htp://localhost:8080/geoserver?service=WMS&request=GetLegendGraphic&format=image/png&width=50&height=100&layer=testAdv&style=style2']"));
        EasyMock.verify((Object[])new Object[]{tld, servReq, response, servInfo});
    }

    String xpathString(String s) {
        StringBuilder b = new StringBuilder();
        int len = s.length();
        b.append("concat('");
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                b.append("',\"'\",'");
                continue;
            }
            b.append(c);
        }
        b.append("')");
        return b.toString();
    }
}

