/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.layer.ProxyLayer;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.wms.WMSGetCapabilities;
import org.geowebcache.service.wms.WMSService;
import org.geowebcache.service.wms.WMSTileFuser;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.PropertyRule;
import org.geowebcache.util.URLMangler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class WMSServiceTest {
    @Rule
    public PropertyRule whitelistProperty = PropertyRule.system((String)"GEOWEBCACHE_WMS_PROXY_REQUEST_WHITELIST");
    private WMSService service;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gridsetBroker;

    @Before
    public void setUp() throws Exception {
        this.sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.gridsetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetConveyorMultipleCrsMatchingGridSubsets() throws Exception {
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
    }

    protected void testMultipleCrsMatchingGridSubsets(String srs, String expectedGridset, long[] tileIndex) throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("format", new String[]{"image/png"});
        kvp.put("srs", new String[]{"EPSG:4326"});
        kvp.put("width", new String[]{"256"});
        kvp.put("height", new String[]{"256"});
        kvp.put("layers", new String[]{"mockLayer"});
        kvp.put("tiled", new String[]{"true"});
        kvp.put("request", new String[]{"GetMap"});
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames);
        BoundingBox bounds = tileLayer.getGridSubset(expectedGridset).boundsFromIndex(tileIndex);
        kvp.put("bbox", new String[]{bounds.toString()});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        ConveyorTile tileRequest = this.service.getConveyor(req, resp);
        Assert.assertNotNull((Object)tileRequest);
        Assert.assertEquals((Object)expectedGridset, (Object)tileRequest.getGridSetId());
        Assert.assertEquals((Object)"image/png", (Object)tileRequest.getMimeType().getMimeType());
        Assert.assertArrayEquals((String)("Expected " + Arrays.toString(tileIndex) + " got " + Arrays.toString(tileRequest.getTileIndex())), (long[])tileIndex, (long[])tileRequest.getTileIndex());
    }

    private TileLayer mockTileLayer(String layerName, List<String> gridSetNames) throws Exception {
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.isAdvertised()).thenReturn((Object)true);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn(Arrays.asList(mimeType1, mimeType2));
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        HashMap<SRS, ArrayList<GridSubset>> bySrs = new HashMap<SRS, ArrayList<GridSubset>>();
        GridSetBroker broker = this.gridsetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            ArrayList<GridSubset> list = (ArrayList<GridSubset>)bySrs.get(gridSet.getSrs());
            if (list == null) {
                list = new ArrayList<GridSubset>();
                bySrs.put(gridSet.getSrs(), list);
            }
            list.add(gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            List list = (List)bySrs.get(srs);
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        for (String gsetName : gridSetNames) {
            Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            Assert.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    @Test
    public void testGetCap() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMS"});
        kvp.put("version", new String[]{"1.1.1"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMSGetCapabilities wmsCap = new WMSGetCapabilities(this.tld, conv.servletReq, "http://localhost:8080", "/service/wms", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp);
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wms-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
    }

    @Test
    public void testGetCapEncoding() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMS"});
        kvp.put("version", new String[]{"1.1.1"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        TileLayer tileLayer = this.mockTileLayer("m\u00f6ckla\u0304yer\ud83d\ude0e", gridSetNames);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMSGetCapabilities wmsCap = new WMSGetCapabilities(this.tld, conv.servletReq, "http://localhost:8080", "/service/wms", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp);
        String capAsString = new String(resp.getContentAsByteArray(), StandardCharsets.UTF_8);
        Assert.assertThat((Object)capAsString, (Matcher)Matchers.containsString((String)"m\u00f6ckla\u0304yer\ud83d\ude0e"));
    }

    @Test
    public void testGetConveyorWithParameters() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        String layerName = "mockLayer";
        String timeValue = "00:00";
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMS"});
        kvp.put("version", new String[]{"1.1.1"});
        kvp.put("request", new String[]{"GetFeatureInfo"});
        kvp.put("layers", new String[]{layerName});
        kvp.put("time", new String[]{timeValue});
        ArrayList<String> mimeFormats = new ArrayList<String>();
        mimeFormats.add("image/png");
        ArrayList<RegexParameterFilter> parameterFilters = new ArrayList<RegexParameterFilter>();
        RegexParameterFilter filter = new RegexParameterFilter();
        filter.setKey("time");
        filter.setRegex("\\d{2}:\\d{2}");
        parameterFilters.add(filter);
        WMSLayer tileLayer = new WMSLayer(layerName, null, null, layerName, mimeFormats, null, parameterFilters, null, null, true, null);
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        Assert.assertNotNull((Object)conv.getLayerId());
        Assert.assertEquals((Object)layerName, (Object)conv.getLayerId());
        Assert.assertFalse((boolean)conv.getFilteringParameters().isEmpty());
        Assert.assertEquals((Object)timeValue, conv.getFilteringParameters().get("TIME"));
    }

    @Test
    public void testProxyRequest() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.testProxyRequestAllowed(secDisp, layerName, tileLayer, "TROZ");
    }

    @Test
    public void testProxyDefaultWhitelistLimitedWhenSecure() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.testProxyRequestPrevented(secDisp, layerName, tileLayer, "TROZ");
    }

    @Test
    public void testProxyRequestSecuredDefaultAllowGetLegendGraphic() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.testProxyRequestAllowed(secDisp, layerName, tileLayer, "GetLegendGraphic");
    }

    @Test
    public void testProxyRequestDefaultWhitelistRestrictedByFilter() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        this.testProxyRequestPrevented(secDisp, layerName, tileLayer, "GetLegendGraphic");
    }

    @Test
    public void testProxyRequestWhitelistWhenNoSecurityFilters() throws Exception {
        this.whitelistProperty.setValue("troz");
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.testProxyRequestAllowed(secDisp, layerName, tileLayer, "TROZ");
        this.testProxyRequestPrevented(secDisp, layerName, tileLayer, "GetLegendGraphic");
    }

    @Test
    public void testProxyRequestWhitelistWithSecurityFilters() throws Exception {
        this.whitelistProperty.setValue("troz");
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        this.testProxyRequestAllowed(secDisp, layerName, tileLayer, "TROZ");
        this.testProxyRequestPrevented(secDisp, layerName, tileLayer, "GetLegendGraphic");
    }

    @Test
    public void testProxyRequestWhitelistWithSecurityFiltersAppliesFilters() throws Exception {
        this.whitelistProperty.setValue("troz");
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        this.testProxyRequestPrevented(secDisp, layerName, tileLayer, "TROZ");
    }

    @Test
    public void testGetCapabilitiesNotAffectedBySecurityFilter() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", new String[]{"WMS"});
        req.addParameter("version", new String[]{"1.1.1"});
        req.addParameter("request", new String[]{"GetCapabilities"});
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetCapabilities");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetCapabilities".toLowerCase())));
        this.service.handleRequest((Conveyor)conv);
    }

    @Test
    public void testGetCapabilitiesNotAffectedByProxyWhitelist() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        this.whitelistProperty.setValue("troz");
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", new String[]{"WMS"});
        req.addParameter("version", new String[]{"1.1.1"});
        req.addParameter("request", new String[]{"GetCapabilities"});
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetCapabilities");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetCapabilities".toLowerCase())));
        this.service.handleRequest((Conveyor)conv);
    }

    @Test
    public void testTileFuseNotAffectedByProxyWhitelist() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        this.whitelistProperty.setValue("troz");
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        final WMSTileFuser fuser = (WMSTileFuser)Mockito.mock(WMSTileFuser.class);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd){

            protected WMSTileFuser getFuser(HttpServletRequest servletReq) throws GeoWebCacheException {
                return fuser;
            }
        };
        this.service.setSecurityDispatcher(secDisp);
        this.service.setFullWMS("true");
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubsetsForSRS(SRS.getEPSG4326())).thenReturn(Collections.singletonList(subset));
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMS");
        req.addParameter("version", "1.1.1");
        req.addParameter("request", "GetMap");
        req.addParameter("layers", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("srs", SRS.getEPSG4326().toString());
        req.addParameter("bbox", "0,0,40,60");
        req.addParameter("width", "40");
        req.addParameter("height", "60");
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetMap&layers=" + layerName + "&format=image/png&srs=" + SRS.getEPSG4326().toString() + "&bbox=0,0,40,60&width=40&height=60");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetMap".toLowerCase())));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        this.service.handleRequest((Conveyor)conv);
        ((WMSTileFuser)Mockito.verify((Object)fuser)).writeResponse((HttpServletResponse)Mockito.same((Object)resp), (RuntimeStats)Mockito.any());
    }

    @Test
    public void testTileFuseSecuredByFilters() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        this.whitelistProperty.setValue("troz");
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        final WMSTileFuser fuser = (WMSTileFuser)Mockito.mock(WMSTileFuser.class);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd){

            protected WMSTileFuser getFuser(HttpServletRequest servletReq) throws GeoWebCacheException {
                return fuser;
            }
        };
        this.service.setSecurityDispatcher(secDisp);
        this.service.setFullWMS("true");
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubsetsForSRS(SRS.getEPSG4326())).thenReturn(Collections.singletonList(subset));
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMS");
        req.addParameter("version", "1.1.1");
        req.addParameter("request", "GetMap");
        req.addParameter("layers", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("srs", SRS.getEPSG4326().toString());
        req.addParameter("bbox", "0,0,40,60");
        req.addParameter("width", "40");
        req.addParameter("height", "60");
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetMap&layers=" + layerName + "&format=image/png&srs=" + SRS.getEPSG4326().toString() + "&bbox=0,0,40,60&width=40&height=60");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetMap".toLowerCase())));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        try {
            this.service.handleRequest((Conveyor)conv);
            Assert.fail((String)"Expected SecurityException");
        }
        catch (SecurityException ex) {
            ((WMSTileFuser)Mockito.verify((Object)fuser, (VerificationMode)Mockito.never())).writeResponse((HttpServletResponse)Mockito.same((Object)resp), (RuntimeStats)Mockito.any());
        }
    }

    @Test
    public void testGetFeature() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubsetsForSRS(SRS.getEPSG4326())).thenReturn(Collections.singletonList(subset));
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Collections.singletonList(XMLMime.gml));
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMS");
        req.addParameter("version", "1.1.1");
        req.addParameter("request", "GetFeatureInfo");
        req.addParameter("layers", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("srs", SRS.getEPSG4326().toString());
        req.addParameter("bbox", "0,0,40,60");
        req.addParameter("width", "40");
        req.addParameter("height", "60");
        req.addParameter("x", "2");
        req.addParameter("y", "3");
        req.addParameter("info_format", XMLMime.gml.getMimeType());
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetFeatureInfo&layers=" + layerName + "&format=image/png&srs=" + SRS.getEPSG4326().toString() + "&bbox=0,0,40,60&width=40&height=60&x=3&y=3");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Mockito.when((Object)tileLayer.getFeatureInfo((ConveyorTile)Mockito.any(ConveyorTile.class), (BoundingBox)Mockito.any(BoundingBox.class), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)new ByteArrayResource("TEST FEATURE INFO".getBytes()));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetFeatureInfo".toLowerCase())));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        this.service.handleRequest((Conveyor)conv);
        Assert.assertThat((Object)resp.getContentAsString(), (Matcher)Matchers.equalTo((Object)"TEST FEATURE INFO"));
    }

    @Test
    public void testGetFeatureSecure() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMSService(this.sb, this.tld, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        String layerName = "mockLayer";
        TestLayer tileLayer = (TestLayer)((Object)Mockito.mock(TestLayer.class));
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubsetsForSRS(SRS.getEPSG4326())).thenReturn(Collections.singletonList(subset));
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Collections.singletonList(XMLMime.gml));
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMS");
        req.addParameter("version", "1.1.1");
        req.addParameter("request", "GetFeatureInfo");
        req.addParameter("layers", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("srs", SRS.getEPSG4326().toString());
        req.addParameter("bbox", "0,0,40,60");
        req.addParameter("width", "40");
        req.addParameter("height", "60");
        req.addParameter("x", "2");
        req.addParameter("y", "3");
        req.addParameter("info_format", XMLMime.gml.getMimeType());
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=GetFeatureInfo&layers=" + layerName + "&format=image/png&srs=" + SRS.getEPSG4326().toString() + "&bbox=0,0,40,60&width=40&height=60&x=3&y=3");
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Mockito.when((Object)tileLayer.getFeatureInfo((ConveyorTile)Mockito.any(ConveyorTile.class), (BoundingBox)Mockito.any(BoundingBox.class), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)new ByteArrayResource("TEST FEATURE INFO".getBytes()));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetFeatureInfo".toLowerCase())));
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        try {
            this.service.handleRequest((Conveyor)conv);
            Assert.fail((String)"Expected SecurityException");
        }
        catch (SecurityException ex) {
            Assert.assertThat((Object)resp.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"TEST FEATURE INFO")));
        }
    }

    protected void testProxyRequestPrevented(SecurityDispatcher mockSecDisp, String layerName, TestLayer mockTileLayer, String requestName) throws GeoWebCacheException {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", new String[]{"WMS"});
        req.addParameter("version", new String[]{"1.1.1"});
        req.addParameter("request", new String[]{requestName});
        req.addParameter("layers", new String[]{layerName});
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=" + requestName + "&layers=" + layerName);
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)requestName.toLowerCase())));
        try {
            this.service.handleRequest((Conveyor)conv);
            Assert.fail((String)"Expected SecurityException");
        }
        catch (SecurityException ex) {
            ((TestLayer)((Object)Mockito.verify((Object)((Object)mockTileLayer), (VerificationMode)Mockito.never()))).proxyRequest(conv);
        }
    }

    protected void testProxyRequestAllowed(SecurityDispatcher mockSecDisp, String layerName, TestLayer mockTileLayer, String requestName) throws GeoWebCacheException {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", new String[]{"WMS"});
        req.addParameter("version", new String[]{"1.1.1"});
        req.addParameter("request", new String[]{requestName});
        req.addParameter("layers", new String[]{layerName});
        req.setRequestURI("/geowebcache/service/wms?service=WMS&version=1.1.1&request=" + requestName + "&layers=" + layerName);
        ConveyorTile conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)requestName.toLowerCase())));
        this.service.handleRequest((Conveyor)conv);
        ((TestLayer)((Object)Mockito.verify((Object)((Object)mockTileLayer)))).proxyRequest(conv);
    }

    protected static abstract class TestLayer
    extends TileLayer
    implements ProxyLayer {
        protected TestLayer() {
        }
    }
}

