/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.io.FileResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.service.wms.WMSTileFuser;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageBroker;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TransientCache;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class WMSTileFuserTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
    SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);

    HttpServletRequest fuserRequest(TileLayer layer, GridSubset gridSubset, BoundingBox bounds, int width, int height) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("layers", layer.getId());
        params.put("srs", gridSubset.getSRS().toString());
        params.put("format", "image/png");
        params.put("bbox", bounds.toString());
        params.put("width", Integer.toString(width));
        params.put("height", Integer.toString(height));
        req.setParameters(params);
        return req;
    }

    @Test
    public void testTileFuserResolution() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-25.0, 17.0, 40.0, 22.0);
        int width = (int)bounds.getWidth() * 10;
        int height = (int)bounds.getHeight() * 10;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        tileFuser.determineSourceResolution();
        Assert.assertEquals((double)0.087890625, (double)tileFuser.srcResolution, (double)8.7890625E-5);
        height = (int)bounds.getWidth() / 10;
        width = (int)bounds.getWidth() / 10;
        tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        tileFuser.determineSourceResolution();
        Assert.assertEquals((long)0L, (long)tileFuser.srcIdx);
        height = (int)bounds.getWidth() * 10000;
        width = (int)bounds.getWidth() * 10000;
        tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        tileFuser.determineSourceResolution();
        Assert.assertEquals((long)10L, (long)tileFuser.srcIdx);
    }

    @Test
    public void testTileFuserLazyCanvasLoading() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        LockProvider lockProvider = (LockProvider)Mockito.mock(LockProvider.class);
        LockProvider.Lock lock = (LockProvider.Lock)Mockito.mock(LockProvider.Lock.class);
        ((LockProvider)Mockito.doReturn((Object)lock).when((Object)lockProvider)).getLock(ArgumentMatchers.anyString());
        layer.setLockProvider(lockProvider);
        BoundingBox bounds = new BoundingBox(-25.0, 17.0, 40.0, 22.0);
        int width = (int)bounds.getWidth() * 10;
        int height = (int)bounds.getHeight() * 10;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        AtomicInteger count = new AtomicInteger();
        Mockito.when((Object)sb.get((TileObject)ArgumentMatchers.any(TileObject.class))).thenAnswer(invoc -> {
            TileObject stObj = (TileObject)invoc.getArguments()[0];
            File imageTile = new File(this.getClass().getResource("/image.png").toURI());
            stObj.setBlob((Resource)new FileResource(imageTile));
            stObj.setCreated(new Date().getTime());
            stObj.setBlobSize(1000);
            if (count.incrementAndGet() == 1) {
                Assert.assertNull((Object)tileFuser.bufferedImageWrapper.canvas);
                return true;
            }
            Assert.assertNotNull((Object)tileFuser.bufferedImageWrapper.canvas);
            return true;
        });
        try (ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("appContextTest.xml");){
            tileFuser.setApplicationContext((ApplicationContext)context);
            tileFuser.setSecurityDispatcher(this.secDisp);
            MockHttpServletResponse response = new MockHttpServletResponse();
            RuntimeStats stats = (RuntimeStats)Mockito.mock(RuntimeStats.class);
            Assert.assertNull((Object)tileFuser.bufferedImageWrapper);
            tileFuser.writeResponse((HttpServletResponse)response, stats);
            Assert.assertNotNull((Object)tileFuser.bufferedImageWrapper);
            Assert.assertNotNull((Object)tileFuser.bufferedImageWrapper.canvas);
        }
    }

    @Test
    public void testTileFuserSecurity() throws Exception {
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)this.secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-25.0, 17.0, 40.0, 22.0);
        int width = (int)bounds.getWidth() * 10;
        int height = (int)bounds.getHeight() * 10;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RuntimeStats stats = (RuntimeStats)Mockito.mock(RuntimeStats.class);
        this.exception.expect(SecurityException.class);
        tileFuser.writeResponse((HttpServletResponse)response, stats);
    }

    @Test
    public void testTileFuserSecurityLayerNotNull() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-25.0, 17.0, 40.0, 22.0);
        int width = (int)bounds.getWidth() * 10;
        int height = (int)bounds.getHeight() * 10;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        Mockito.when((Object)sb.get((TileObject)ArgumentMatchers.any(TileObject.class))).thenAnswer(invoc -> {
            TileObject stObj = (TileObject)invoc.getArguments()[0];
            File imageTile = new File(this.getClass().getResource("/image.png").toURI());
            stObj.setBlob((Resource)new FileResource(imageTile));
            stObj.setCreated(new Date().getTime());
            stObj.setBlobSize(1000);
            return true;
        });
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        try (ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("appContextTest.xml");){
            tileFuser.setApplicationContext((ApplicationContext)context);
            tileFuser.setSecurityDispatcher(this.secDisp);
            MockHttpServletResponse response = new MockHttpServletResponse();
            RuntimeStats stats = (RuntimeStats)Mockito.mock(RuntimeStats.class);
            tileFuser.writeResponse((HttpServletResponse)response, stats);
            ((SecurityDispatcher)Mockito.verify((Object)this.secDisp, (VerificationMode)Mockito.times((int)4))).checkSecurity((ConveyorTile)ArgumentMatchers.any(ConveyorTile.class));
        }
    }

    @Test
    public void testTileFuserSubset() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-25.0, 17.0, 40.0, 22.0);
        int width = (int)bounds.getWidth() * 10;
        int height = (int)bounds.getHeight() * 10;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        tileFuser.determineSourceResolution();
        tileFuser.determineCanvasLayout();
        Assert.assertTrue((boolean)tileFuser.srcBounds.contains(bounds));
        WMSTileFuser.PixelOffsets comparison = new WMSTileFuser.PixelOffsets();
        comparison.left = -228;
        comparison.bottom = -193;
        comparison.right = -56;
        comparison.top = -6;
        Assert.assertEquals((long)comparison.left, (long)tileFuser.canvOfs.left);
        Assert.assertEquals((long)comparison.bottom, (long)tileFuser.canvOfs.bottom);
        Assert.assertEquals((long)comparison.right, (long)tileFuser.canvOfs.right);
        Assert.assertEquals((long)comparison.top, (long)tileFuser.canvOfs.top);
    }

    @Test
    public void testTileFuserSuperset() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-35.0, 14.0, 55.0, 39.0);
        int width = (int)bounds.getWidth() * 25;
        int height = (int)bounds.getHeight() * 25;
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        Mockito.when((Object)tld.getTileLayer("test:layer")).thenReturn((Object)layer);
        StorageBroker sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        WMSTileFuser tileFuser = new WMSTileFuser(tld, sb, this.fuserRequest((TileLayer)layer, gridSubset, bounds, width, height));
        tileFuser.setSecurityDispatcher(this.secDisp);
        tileFuser.determineSourceResolution();
        tileFuser.determineCanvasLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteResponse() throws Exception {
        WMSLayer layer = this.createWMSLayer();
        BoundingBox bounds = new BoundingBox(-35.0, 14.0, 55.0, 39.0);
        int width = (int)bounds.getWidth() * 25;
        int height = (int)bounds.getHeight() * 25;
        layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        File temp = File.createTempFile("gwc", "wms");
        temp.delete();
        temp.mkdirs();
        try {
            TileLayerDispatcher dispatcher = new TileLayerDispatcher(this.gridSetBroker, null, (TileLayer)layer){
                final /* synthetic */ TileLayer val$layer;
                {
                    this.val$layer = tileLayer;
                    super(gridSetBroker, tileLayerDispatcherFilter);
                }

                public TileLayer getTileLayer(String layerName) throws GeoWebCacheException {
                    return this.val$layer;
                }
            };
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("layers", new String[]{"test:layer"});
            request.addParameter("srs", new String[]{"EPSG:4326"});
            request.addParameter("format", new String[]{"image/png8"});
            request.addParameter("width", "" + width);
            request.addParameter("height", "" + height);
            request.addParameter("bbox", bounds.toString());
            final File imageTile = new File(this.getClass().getResource("/image.png").toURI());
            DefaultStorageBroker broker = new DefaultStorageBroker((BlobStore)new FileBlobStore(temp.getAbsolutePath()){

                public boolean get(TileObject stObj) throws StorageException {
                    stObj.setBlob((Resource)new FileResource(imageTile));
                    stObj.setCreated(new Date().getTime());
                    stObj.setBlobSize(1000);
                    return true;
                }
            }, new TransientCache(100, 1024, 2000L));
            WMSTileFuser tileFuser = new WMSTileFuser(dispatcher, (StorageBroker)broker, (HttpServletRequest)request);
            tileFuser.setSecurityDispatcher(this.secDisp);
            try (ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("appContextTest.xml");){
                tileFuser.setApplicationContext((ApplicationContext)context);
                MockHttpServletResponse response = new MockHttpServletResponse();
                tileFuser.writeResponse((HttpServletResponse)response, new RuntimeStats(1, Arrays.asList(1), Arrays.asList("desc")));
                Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(response.getContentAsByteArray()));
                Assert.assertEquals((long)width, (long)image.getWidth());
                Assert.assertEquals((long)height, (long)image.getHeight());
            }
        }
        finally {
            temp.delete();
        }
    }

    private WMSLayer createWMSLayer() {
        String[] urls = new String[]{"http://localhost:38080/wms"};
        LinkedList<String> formatList = new LinkedList<String>();
        formatList.add("image/png");
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>();
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)new BoundingBox(-30.0, 15.0, 45.0, 30.0), (Integer)0, (Integer)10);
        grids.put(grid.getName(), grid);
        int[] metaWidthHeight = new int[]{3, 3};
        WMSLayer layer = new WMSLayer("test:layer", urls, "aStyle", "test:layer", formatList, grids, null, metaWidthHeight, "vendorparam=true", false, null);
        layer.setLockProvider((LockProvider)Mockito.mock(LockProvider.class));
        layer.setSourceHelper((WMSSourceHelper)Mockito.mock(WMSSourceHelper.class));
        layer.initialize(this.gridSetBroker);
        return layer;
    }
}

