/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.config.legends.LegendInfoBuilder;
import org.geowebcache.config.meta.ServiceContact;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.config.meta.ServiceProvider;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.XMLBuilder;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.wmts.WMTSExtension;
import org.geowebcache.service.wmts.WMTSExtensionImpl;
import org.geowebcache.service.wmts.WMTSGetCapabilities;
import org.geowebcache.service.wmts.WMTSService;
import org.geowebcache.service.wmts.WMTSTileJSON;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.URLMangler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;

public class WMTSServiceTest {
    private WMTSService service;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gridsetBroker;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File configDir;
    private File configFile;

    @Before
    public void setUp() throws Exception {
        this.sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.gridsetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
    }

    private TileLayerDispatcher mockTileLayerDispatcher() throws Exception {
        XMLConfiguration config2 = this.getConfig();
        ApplicationContext appContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        HashMap<String, Object> beans = new HashMap<String, Object>(2);
        DefaultGridsets defaultGridSets = new DefaultGridsets(true, true);
        beans.put("defaultGridSets", defaultGridSets);
        beans.put("xmlConfig", config2);
        Mockito.when((Object)appContext.getBeansOfType(GridSetConfiguration.class)).thenReturn(beans);
        Mockito.when((Object)appContext.getBean("defaultGridSets")).thenReturn((Object)defaultGridSets);
        Mockito.when((Object)appContext.getBean("xmlConfig")).thenReturn((Object)config2);
        Mockito.when((Object)((BaseConfiguration)appContext.getBean(BaseConfiguration.class))).thenReturn((Object)config2);
        Mockito.when((Object)appContext.getBeansOfType(BaseConfiguration.class)).thenReturn(Collections.singletonMap("xmlConfig", config2));
        TileLayerDispatcher tldx = new TileLayerDispatcher(this.gridsetBroker, null);
        tldx.setApplicationContext(appContext);
        tldx.afterPropertiesSet();
        return tldx;
    }

    protected XMLConfiguration getConfig() throws Exception {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            URL source = this.getClass().getResource("geowebcache_190.xml");
            Assert.assertNotNull((Object)source);
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
        this.gridsetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        XMLFileResourceProvider configProvider = new XMLFileResourceProvider("geowebcache.xml", (WebApplicationContext)null, this.configDir.getAbsolutePath(), null);
        XMLConfiguration config = new XMLConfiguration(null, (ConfigurationResourceProvider)configProvider);
        config.setGridSetBroker(this.gridsetBroker);
        config.afterPropertiesSet();
        return config;
    }

    private TileLayer mockTileLayer(String layerName, List<String> gridSetNames, List<ParameterFilter> parameterFilters) throws Exception {
        return this.mockTileLayer(layerName, gridSetNames, parameterFilters, true);
    }

    private TileLayer mockTileLayer(String layerName, List<String> gridSetNames, List<ParameterFilter> parameterFilters, boolean advertised) throws Exception {
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.isAdvertised()).thenReturn((Object)advertised);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn(Arrays.asList(mimeType1, mimeType2));
        MimeType infoMimeType1 = MimeType.createFromFormat((String)"text/plain");
        MimeType infoMimeType2 = MimeType.createFromFormat((String)"text/html");
        MimeType infoMimeType3 = MimeType.createFromFormat((String)"application/vnd.ogc.gml");
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Arrays.asList(infoMimeType1, infoMimeType2, infoMimeType3));
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        HashMap<SRS, ArrayList<GridSubset>> bySrs = new HashMap<SRS, ArrayList<GridSubset>>();
        GridSetBroker broker = this.gridsetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            ArrayList<GridSubset> list = (ArrayList<GridSubset>)bySrs.get(gridSet.getSrs());
            if (list == null) {
                list = new ArrayList<GridSubset>();
                bySrs.put(gridSet.getSrs(), list);
            }
            list.add(gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            List list = (List)bySrs.get(srs);
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        Mockito.when((Object)tileLayer.getParameterFilters()).thenReturn(parameterFilters);
        for (String gsetName : gridSetNames) {
            Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            Assert.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    private TileLayer mockTileLayerWithJSONSupport(String layerName, List<String> gridSetNames) throws Exception {
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{TileJSONProvider.class}));
        Mockito.when((Object)this.tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.isAdvertised()).thenReturn((Object)true);
        ImageMime mimeType1 = ImageMime.png;
        ApplicationMime mimeType2 = ApplicationMime.mapboxVector;
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn(Arrays.asList(mimeType1, mimeType2));
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        HashMap<SRS, ArrayList<GridSubset>> bySrs = new HashMap<SRS, ArrayList<GridSubset>>();
        GridSetBroker broker = this.gridsetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            ArrayList<GridSubset> list = (ArrayList<GridSubset>)bySrs.get(gridSet.getSrs());
            if (list == null) {
                list = new ArrayList<GridSubset>();
                bySrs.put(gridSet.getSrs(), list);
            }
            list.add(gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            List list = (List)bySrs.get(srs);
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        TileJSONProvider tileJSONProvider = (TileJSONProvider)tileLayer;
        Mockito.when((Object)tileJSONProvider.supportsTileJSON()).thenReturn((Object)true);
        TileJSON json = new TileJSON();
        VectorLayerMetadata metadata = new VectorLayerMetadata();
        metadata.setFields(Collections.singletonMap("FIELD", "TYPE"));
        json.setLayers(Collections.singletonList(metadata));
        Mockito.when((Object)tileJSONProvider.getTileJSON()).thenReturn((Object)json);
        for (String gsetName : gridSetNames) {
            Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            Assert.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    @Test
    public void testGetCap() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.emptyList());
        TileLayer tileLayerUn = this.mockTileLayer("mockLayerUnadv", gridSetNames, Collections.emptyList(), false);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        StringParameterFilter styles = new StringParameterFilter();
        styles.setKey("STYLES");
        styles.setValues(Arrays.asList("style-a", "style-b"));
        Mockito.when((Object)tileLayer.getParameterFilters()).thenReturn(Collections.singletonList(styles));
        LegendInfo legendInfo1 = new LegendInfoBuilder().withStyleName("style-a-legend").withWidth(Integer.valueOf(250)).withHeight(Integer.valueOf(500)).withFormat("image/jpeg").withCompleteUrl("https://some-url?some-parameter=value1&another-parameter=value2").build();
        HashMap<String, LegendInfo> legends = new HashMap<String, LegendInfo>();
        legends.put("style-a", legendInfo1);
        LegendInfo legendInfo2 = new LegendInfoBuilder().withStyleName("styla-b-legend").withWidth(Integer.valueOf(125)).withHeight(Integer.valueOf(130)).withFormat("image/png").withCompleteUrl("https://some-url?some-parameter=value3&another-parameter=value4").withMinScale(Double.valueOf(5000.0)).withMaxScale(Double.valueOf(10000.0)).build();
        legends.put("style-b", legendInfo2);
        Mockito.when((Object)tileLayer.getLayerLegendsInfo()).thenReturn(legends);
        MetadataURL metadataURL = new MetadataURL("some-type", "some-format", new URL("http://localhost:8080/some-url"));
        Mockito.when((Object)tileLayer.getMetadataURLs()).thenReturn(Collections.singletonList(metadataURL));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("mockLayer"));
        Assert.assertFalse((boolean)result.contains("mockLayerUnadv"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xp = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"2", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier)", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style[ows:Identifier='style-a'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style[ows:Identifier='style-a']/wmts:LegendURL[@width='250'][@height='500'][@format='image/jpeg'][@xlink:href='https://some-url?some-parameter=value1&another-parameter=value2'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style[ows:Identifier='style-b']/wmts:LegendURL[@width='125'][@height='130'][@format='image/png'][@minScaleDenominator='5000.0'][@maxScaleDenominator='10000.0'][@xlink:href='https://some-url?some-parameter=value3&another-parameter=value4'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:MetadataURL[@type='some-type'][wmts:Format='some-format'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:MetadataURL[@type='some-type']/wmts:OnlineResource[@xlink:href='http://localhost:8080/some-url'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='tile'][@format='image/jpeg'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/jpeg'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='tile'][@format='image/png'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/png'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='FeatureInfo'][@format='text/plain'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=text/plain'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='FeatureInfo'][@format='text/html'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=text/html'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='FeatureInfo'][@format='application/vnd.ogc.gml'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=application/vnd.ogc.gml'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:ServiceMetadataURL[@xlink:href='http://localhost:8080/geowebcache/service/wmts?SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0'])", doc));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wmts:ServiceMetadataURL[@xlink:href='http://localhost:8080/geowebcache/service/wmts/rest/WMTSCapabilities.xml'])", doc));
        String matrices = "/wmts:Capabilities/wmts:Contents/wmts:TileMatrixSet";
        Assert.assertEquals((Object)"3", (Object)xp.evaluate("count(" + matrices + ")", doc));
        Assert.assertNotEquals((Object)"", (Object)xp.evaluate(matrices + "[ows:Identifier = 'EPSG:4326']", doc));
        Assert.assertNotEquals((Object)"", (Object)xp.evaluate(matrices + "[ows:Identifier = 'GlobalCRS84Scale']", doc));
        Assert.assertNotEquals((Object)"", (Object)xp.evaluate(matrices + "[ows:Identifier = 'GlobalCRS84Pixel']", doc));
    }

    @Test
    public void testGetCapWithExtensions() throws Exception {
        ArrayList<Object> extensions = new ArrayList<Object>();
        extensions.add(new WMTSExtension(){

            public String[] getSchemaLocations() {
                return new String[]{"name-space schema-location"};
            }

            public void registerNamespaces(XMLBuilder xml) throws IOException {
                xml.attribute("xmlns:custom", "custom");
            }

            public void encodedOperationsMetadata(XMLBuilder xml) throws IOException {
                xml.startElement("custom-metadata");
                xml.endElement("custom-metadata");
            }

            public List<WMTSExtension.OperationMetadata> getExtraOperationsMetadata() throws IOException {
                return Arrays.asList(new WMTSExtension.OperationMetadata("ExtraOperation1"), new WMTSExtension.OperationMetadata("ExtraOperation2", "custom-url"));
            }

            public ServiceInformation getServiceInformation() {
                ServiceInformation serviceInformation = new ServiceInformation();
                serviceInformation.setTitle("custom-service");
                return serviceInformation;
            }

            public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response, StorageBroker storageBroker) throws GeoWebCacheException, OWSException {
                return null;
            }

            public boolean handleRequest(Conveyor conveyor) throws OWSException {
                return false;
            }

            public void encodeLayer(XMLBuilder xmlBuilder, TileLayer tileLayer) throws IOException {
                xmlBuilder.simpleElement("extra-layer-metadata", "metadatada", true);
            }
        });
        extensions.add(new WMTSExtensionImpl(){

            public ServiceInformation getServiceInformation() {
                ServiceInformation serviceInformation = new ServiceInformation();
                ServiceProvider serviceProvider = new ServiceProvider();
                serviceProvider.setProviderName("custom-provider");
                serviceInformation.setServiceProvider(serviceProvider);
                ServiceContact contactInformation = new ServiceContact();
                contactInformation.setPositionName("custom-position");
                serviceProvider.setServiceContact(contactInformation);
                return serviceInformation;
            }
        });
        extensions.add(new WMTSExtensionImpl());
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        extensions.forEach(arg_0 -> ((WMTSService)this.service).addExtension(arg_0));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.emptyList());
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singletonList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singletonList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/service/wmts", (URLMangler)new NullURLMangler(), extensions);
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("xmlns:custom=\"custom\""));
        Assert.assertTrue((boolean)result.contains("name-space schema-location"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:custom-metadata)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:ServiceIdentification[ows:Title='custom-service'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:ServiceProvider[ows:ProviderName='custom-provider'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:ServiceProvider/ows:ServiceContact[ows:PositionName='custom-position'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:OperationsMetadata/ows:Operation[@name='ExtraOperation1'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:OperationsMetadata/ows:Operation[@name='ExtraOperation1']/ows:DCP/ows:HTTP/ows:Get[@xlink:href='http://localhost:8080/service/wmts/service/wmts?'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:OperationsMetadata/ows:Operation[@name='ExtraOperation2'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:OperationsMetadata/ows:Operation[@name='ExtraOperation2']/ows:DCP/ows:HTTP/ows:Get[@xlink:href='custom-url?'])", doc));
        xpath.evaluate("count(//wmts:Contents/wmts:Layer[wmts:extra-layer-metadata='metadatada'])", doc);
    }

    @Test
    public void testGetCapServiceInfo() throws Exception {
        TileLayerDispatcher tldx = this.mockTileLayerDispatcher();
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, tldx, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326", "EPSG:900913");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.emptyList());
        TileLayer tileLayerUn = this.mockTileLayer("mockLayerUnadv", gridSetNames, Collections.emptyList(), false);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        GridSubset wgs84Subset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)wgs84Subset.getOriginalExtent()).thenReturn((Object)new BoundingBox(-42.0, -24.0, 40.0, 50.0));
        GridSubset googleSubset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)googleSubset.getOriginalExtent()).thenReturn((Object)new BoundingBox(1000000.0, 2000000.0, 1000000.0, 2000000.0));
        Mockito.when((Object)tileLayer.getGridSubsetForSRS(SRS.getEPSG4326())).thenReturn((Object)wgs84Subset);
        Mockito.when((Object)tileLayer.getGridSubsetForSRS(SRS.getEPSG900913())).thenReturn((Object)googleSubset);
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(tldx, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("ServiceContact"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"John Smith", (Object)xpath.evaluate("//ows:IndividualName", doc));
    }

    @Test
    public void testGetCapOneWGS84BBox() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326", "EPSG:900913");
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.emptyList());
        TileLayer tileLayerUn = this.mockTileLayer("mockLayerUnadv", gridSetNames, Collections.emptyList(), false);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer, tileLayerUn));
        GridSubset wgs84Subset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)wgs84Subset.getOriginalExtent()).thenReturn((Object)new BoundingBox(-42.0, -24.0, 40.0, 50.0));
        GridSubset googleSubset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)googleSubset.getOriginalExtent()).thenReturn((Object)new BoundingBox(1000000.0, 2000000.0, 1000000.0, 2000000.0));
        Mockito.when((Object)tileLayer.getGridSubsetForSRS(SRS.getEPSG4326())).thenReturn((Object)wgs84Subset);
        Mockito.when((Object)tileLayer.getGridSubsetForSRS(SRS.getEPSG900913())).thenReturn((Object)googleSubset);
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("mockLayer"));
        Assert.assertFalse((boolean)result.contains("mockLayerUnadv"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//ows:WGS84BoundingBox)", doc));
    }

    @Test
    public void testGetCapUnboundedStyleFilter() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        ParameterFilter styleFilter = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)styleFilter.getKey()).thenReturn((Object)"STYLES");
        Mockito.when((Object)styleFilter.getDefaultValue()).thenReturn((Object)"Foo");
        Mockito.when((Object)styleFilter.getLegalValues()).thenReturn(null);
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.singletonList(styleFilter));
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier)", doc));
        Assert.assertEquals((Object)"", (Object)xpath.evaluate("//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier", doc));
    }

    @Test
    public void testGetCapEmptyStyleFilter() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        ParameterFilter styleFilter = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)styleFilter.getKey()).thenReturn((Object)"STYLES");
        Mockito.when((Object)styleFilter.getDefaultValue()).thenReturn((Object)"Foo");
        Mockito.when((Object)styleFilter.getLegalValues()).thenReturn(Collections.emptyList());
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.singletonList(styleFilter));
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Validator validator = new Validator(result);
        validator.useXMLSchema(true);
        validator.assertIsValid();
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier)", doc));
        Assert.assertEquals((Object)"", (Object)xpath.evaluate("//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier", doc));
    }

    @Test
    public void testGetCapMultipleStyles() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        ParameterFilter styleFilter = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)styleFilter.getKey()).thenReturn((Object)"STYLES");
        Mockito.when((Object)styleFilter.getDefaultValue()).thenReturn((Object)"Foo");
        Mockito.when((Object)styleFilter.getLegalValues()).thenReturn(Arrays.asList("Foo", "Bar", "Baz"));
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.singletonList(styleFilter));
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"3", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']/wmts:Style/ows:Identifier)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']/wmts:Style[@isDefault='true']/ows:Identifier)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']/wmts:Style[@isDefault='true']/ows:Identifier[text()='Foo'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']/wmts:Style/ows:Identifier[text()='Bar'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']/wmts:Style/ows:Identifier[text()='Baz'])", doc));
    }

    @Test
    public void testGetCapWithMultipleDimensions() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        ParameterFilter styleFilter = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)styleFilter.getKey()).thenReturn((Object)"STYLES");
        Mockito.when((Object)styleFilter.getDefaultValue()).thenReturn((Object)"Foo");
        Mockito.when((Object)styleFilter.getLegalValues()).thenReturn(Arrays.asList("Foo", "Bar", "Baz"));
        ParameterFilter elevationDimension = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)elevationDimension.getKey()).thenReturn((Object)"elevation");
        Mockito.when((Object)elevationDimension.getDefaultValue()).thenReturn((Object)"0");
        Mockito.when((Object)elevationDimension.getLegalValues()).thenReturn(Arrays.asList("0", "200", "400", "600"));
        ParameterFilter timeDimension = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)timeDimension.getKey()).thenReturn((Object)"time");
        Mockito.when((Object)timeDimension.getDefaultValue()).thenReturn((Object)"2016-02-23T03:00:00.00");
        Mockito.when((Object)timeDimension.getLegalValues()).thenReturn(Collections.emptyList());
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Arrays.asList(styleFilter, elevationDimension, timeDimension));
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"5", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[contains(@template,'&elevation={elevation}&time={time}')])", doc));
        Assert.assertEquals((Object)"2", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Dimension/ows:Identifier)", doc));
    }

    @Test
    public void testGetTileWithStyle() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetTile"});
        kvp.put("layer", new String[]{"mockLayer"});
        kvp.put("format", new String[]{"image/png"});
        kvp.put("TileMatrixSet", new String[]{"GlobalCRS84Pixel"});
        kvp.put("TileMatrix", new String[]{"GlobalCRS84Pixel:1"});
        kvp.put("TileRow", new String[]{"0"});
        kvp.put("TileCol", new String[]{"0"});
        kvp.put("Style", new String[]{"Bar"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        ParameterFilter styleFilter = (ParameterFilter)Mockito.mock(ParameterFilter.class);
        Mockito.when((Object)styleFilter.getKey()).thenReturn((Object)"STYLES");
        Mockito.when((Object)styleFilter.getDefaultValue()).thenReturn((Object)"Foo");
        Mockito.when((Object)styleFilter.getLegalValues()).thenReturn(Arrays.asList("Foo", "Bar", "Baz"));
        TileLayer tileLayer = this.mockTileLayer("mockLayer", gridSetNames, Collections.singletonList(styleFilter));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("STYLES", "Bar");
        Mockito.when((Object)tileLayer.getModifiableParameters((Map)ArgumentMatchers.argThat(m -> Matchers.hasEntry((Matcher)Matchers.equalToIgnoringCase((String)"styles"), (Matcher)Matchers.arrayContaining((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"Bar")})).matches(m)), (String)ArgumentMatchers.any())).thenReturn(Collections.unmodifiableMap(map));
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertEquals((Object)"mockLayer", (Object)layerName);
        MatcherAssert.assertThat((Object)conv, (Matcher)CoreMatchers.instanceOf(ConveyorTile.class));
        ConveyorTile tile = (ConveyorTile)conv;
        Map parameters = tile.getParameters();
        MatcherAssert.assertThat((Object)parameters, (Matcher)Matchers.hasEntry((Object)"STYLES", (Object)"Bar"));
    }

    @Test
    public void testDispatchCustomOperations() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"CustomOperation"});
        final HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        this.service.addExtension((WMTSExtension)new WMTSExtensionImpl(){

            public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response, StorageBroker storageBroker) throws GeoWebCacheException, OWSException {
                if (((String[])request.getParameterMap().get("request"))[0].equalsIgnoreCase("CustomOperation")) {
                    ConveyorTile conveyor = new ConveyorTile(WMTSServiceTest.this.sb, null, req, (HttpServletResponse)resp);
                    conveyor.setHint("CustomOperation");
                    return conveyor;
                }
                return null;
            }

            public boolean handleRequest(Conveyor conveyor) throws OWSException {
                if (conveyor.getHint().equalsIgnoreCase("CustomOperation")) {
                    try (ServletOutputStream os = conveyor.servletResp.getOutputStream();){
                        os.write("CustomOperation Result".getBytes());
                        os.flush();
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                    return true;
                }
                return false;
            }
        });
        Conveyor conveyor = this.service.getConveyor(req, (HttpServletResponse)resp);
        MatcherAssert.assertThat((Object)conveyor, (Matcher)CoreMatchers.notNullValue());
        this.service.handleRequest(conveyor);
        MatcherAssert.assertThat((Object)resp.getContentAsString(), (Matcher)Matchers.equalTo((Object)"CustomOperation Result"));
    }

    @Test
    public void testGetFeature() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        GridSetBroker gsb = (GridSetBroker)Mockito.mock(GridSetBroker.class);
        this.service = new WMTSService(this.sb, this.tld, gsb, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        GridSet set = (GridSet)Mockito.mock(GridSet.class);
        Mockito.when((Object)subset.getName()).thenReturn((Object)"testGridset");
        Mockito.when((Object)subset.getGridSet()).thenReturn((Object)set);
        Mockito.when((Object)subset.boundsFromIndex((long[])ArgumentMatchers.any())).thenReturn((Object)new BoundingBox(0.0, 0.0, 180.0, 90.0));
        Mockito.when((Object)set.getTileHeight()).thenReturn((Object)256);
        Mockito.when((Object)set.getTileWidth()).thenReturn((Object)256);
        String layerName = "mockLayer";
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubset("testGridset")).thenReturn((Object)subset);
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Collections.singletonList(XMLMime.gml));
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMTS");
        req.addParameter("version", "1.0.0");
        req.addParameter("request", "GetFeatureInfo");
        req.addParameter("layer", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("tilematrixset", "testGridset");
        req.addParameter("tilematrix", "testGridset:2");
        req.addParameter("tilerow", "3");
        req.addParameter("tilecol", "4");
        req.addParameter("infoformat", XMLMime.gml.getMimeType());
        req.addParameter("i", "20");
        req.addParameter("j", "50");
        req.setRequestURI("/geowebcache/service/wmts?service=WMTS&version=1.0.0&request=GetFeatureInfo&layer=" + layerName + "&format=image/png&tilematrixset=testGridset&tilematrix=testGridset:2&tilerow=3&tilecol=4&infoformat=" + XMLMime.gml.getMimeType());
        Mockito.when((Object)subset.getNumTilesHigh(2)).thenReturn((Object)7L);
        Mockito.when((Object)subset.getGridIndex("testGridset:2")).thenReturn((Object)2L);
        Mockito.when((Object)subset.getCoverage(2)).thenReturn((Object)new long[]{1L, 1L, 8L, 8L});
        Conveyor conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"gridSetId", (Matcher)Matchers.equalTo((Object)"testGridset")));
        Mockito.when((Object)tileLayer.getFeatureInfo((ConveyorTile)ArgumentMatchers.any(ConveyorTile.class), (BoundingBox)ArgumentMatchers.any(BoundingBox.class), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)new ByteArrayResource("TEST FEATURE INFO".getBytes()));
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetFeatureInfo".toLowerCase())));
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        this.service.handleRequest(conv);
        MatcherAssert.assertThat((Object)resp.getContentAsString(), (Matcher)Matchers.equalTo((Object)"TEST FEATURE INFO"));
    }

    @Test
    public void testGetFeatureSecure() throws Exception {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)true);
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        GridSetBroker gsb = (GridSetBroker)Mockito.mock(GridSetBroker.class);
        this.service = new WMTSService(this.sb, this.tld, gsb, (RuntimeStats)Mockito.mock(RuntimeStats.class), (URLMangler)new NullURLMangler(), gwcd);
        this.service.setSecurityDispatcher(secDisp);
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        GridSet set = (GridSet)Mockito.mock(GridSet.class);
        Mockito.when((Object)subset.getName()).thenReturn((Object)"testGridset");
        Mockito.when((Object)subset.getGridSet()).thenReturn((Object)set);
        Mockito.when((Object)set.getTileHeight()).thenReturn((Object)256);
        Mockito.when((Object)set.getTileWidth()).thenReturn((Object)256);
        String layerName = "mockLayer";
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)this.tld.getTileLayer(layerName)).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singleton(tileLayer));
        Mockito.when((Object)tileLayer.getGridSubset("testGridset")).thenReturn((Object)subset);
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Collections.singletonList(XMLMime.gml));
        ((SecurityDispatcher)Mockito.doThrow((Throwable[])new Throwable[]{new SecurityException()}).when((Object)secDisp)).checkSecurity((ConveyorTile)Mockito.any());
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        req.addParameter("service", "WMTS");
        req.addParameter("version", "1.0.0");
        req.addParameter("request", "GetFeatureInfo");
        req.addParameter("layer", layerName);
        req.addParameter("format", "image/png");
        req.addParameter("tilematrixset", "testGridset");
        req.addParameter("tilematrix", "testGridset:2");
        req.addParameter("tilerow", "3");
        req.addParameter("tilecol", "4");
        req.addParameter("infoformat", XMLMime.gml.getMimeType());
        req.addParameter("i", "20");
        req.addParameter("j", "50");
        req.setRequestURI("/geowebcache/service/wmts?service=WMTS&version=1.0.0&request=GetFeatureInfo&layer=" + layerName + "&format=image/png&tilematrixset=testGridset&tilematrix=testGridset:2&tilerow=3&tilecol=4&infoformat=" + XMLMime.gml.getMimeType());
        Mockito.when((Object)subset.getNumTilesHigh(2)).thenReturn((Object)7L);
        Mockito.when((Object)subset.getGridIndex("testGridset:2")).thenReturn((Object)2L);
        Mockito.when((Object)subset.getCoverage(2)).thenReturn((Object)new long[]{1L, 1L, 8L, 8L});
        Conveyor conv = this.service.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"gridSetId", (Matcher)Matchers.equalTo((Object)"testGridset")));
        Mockito.when((Object)tileLayer.getFeatureInfo((ConveyorTile)ArgumentMatchers.any(ConveyorTile.class), (BoundingBox)ArgumentMatchers.any(BoundingBox.class), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)new ByteArrayResource("TEST FEATURE INFO".getBytes()));
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"hint", (Matcher)Matchers.equalTo((Object)"GetFeatureInfo".toLowerCase())));
        MatcherAssert.assertThat((Object)conv, (Matcher)Matchers.hasProperty((String)"requestHandler", (Matcher)Matchers.equalTo((Object)Conveyor.RequestHandler.SERVICE)));
        try {
            this.service.handleRequest(conv);
            Assert.fail((String)"Expected SecurityException");
        }
        catch (SecurityException ex) {
            MatcherAssert.assertThat((Object)resp.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"TEST FEATURE INFO")));
        }
    }

    @Test
    public void testGetCapWithTileJSONDifferentUrls() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new WMTSService(this.sb, this.tld, null, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap();
        kvp.put("service", new String[]{"WMTS"});
        kvp.put("version", new String[]{"1.0.0"});
        kvp.put("request", new String[]{"GetCapabilities"});
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        List<String> gridSetNames = Arrays.asList("EPSG:900913");
        TileLayer tileLayer = this.mockTileLayerWithJSONSupport("mockLayer", gridSetNames);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Collections.singletonList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Collections.singletonList(tileLayer));
        Conveyor conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        WMTSGetCapabilities wmsCap = new WMTSGetCapabilities(this.tld, this.gridsetBroker, conv.servletReq, "http://localhost:8080", "/geowebcache", (URLMangler)new NullURLMangler());
        wmsCap.writeResponse(conv.servletResp, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        Assert.assertTrue((boolean)resp.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline;filename=wmts-getcapabilities.xml", (Object)resp.getHeader("content-disposition"));
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("mockLayer"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer)", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='TileJSON'][@format='application/json'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/tilejson/png?format=application/json'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='TileJSON'][@format='application/json'][@template='http://localhost:8080/geowebcache/service/wmts/rest/mockLayer/{style}/tilejson/pbf?format=application/json'])", doc));
        kvp.put("request", new String[]{"GetTileJSON"});
        kvp.put("tileformat", new String[]{"pbf"});
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        result = this.writeTileJsonResponse((ConveyorTile)conv, tileLayer, resp);
        Assert.assertTrue((boolean)result.contains("\"tiles\":[\"http://localhost/service/wmts/rest/mockLayer/EPSG:900913/EPSG:900913:{z}/{y}/{x}?format=application/vnd.mapbox-vector-tile\"]"));
        kvp.put("tileformat", new String[]{"png"});
        Mockito.when((Object)req.getParameterMap()).thenReturn((Object)kvp);
        conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        result = this.writeTileJsonResponse((ConveyorTile)conv, tileLayer, resp);
        Assert.assertTrue((boolean)result.contains("\"tiles\":[\"http://localhost/service/wmts/rest/mockLayer/EPSG:900913/EPSG:900913:{z}/{y}/{x}?format=image/png\"]"));
    }

    private String writeTileJsonResponse(ConveyorTile conv, TileLayer tileLayer, MockHttpServletResponse resp) throws UnsupportedEncodingException {
        WMTSTileJSON tileJSON = new WMTSTileJSON(conv, "http://localhost", "", null, (URLMangler)new NullURLMangler());
        tileJSON.writeResponse(tileLayer);
        return resp.getContentAsString();
    }
}

