/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.HttpErrorException;
import it.geosolutions.httpproxy.ProxyCallback;
import it.geosolutions.httpproxy.ProxyConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class HostChecker
implements ProxyCallback {
    ProxyConfig config;

    public HostChecker(ProxyConfig config) {
        this.config = config;
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response, URL url) throws IOException {
        String host;
        Set<String> hosts = this.config.getHostsWhitelist();
        if (hosts != null && hosts.size() > 0 && !hosts.contains(host = this.getRemoteAddr(request))) {
            throw new HttpErrorException(403, "Client Host " + host + " is not among the ones allowed for this proxy");
        }
    }

    @Override
    public void onRemoteResponse(HttpRequestBase method) throws IOException {
    }

    @Override
    public void onFinish() throws IOException {
    }

    private String getRemoteAddr(HttpServletRequest req) {
        String forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            String[] ips = forwardedFor.split(", ");
            return ips[0];
        }
        return req.getRemoteAddr();
    }
}

