/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.ProxyInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    static final int DEFAULT_MAX_FILE_UPLOAD_SIZE = 0x500000;
    static final File DEFAULT_FILE_UPLOAD_TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    static final String LOCATION_HEADER = "Location";
    static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    static final String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    static final String HOST_HEADER_NAME = "Host";
    static final String HTTP_HEADER_ACCEPT_ENCODING = "accept-encoding";
    static final String HTTP_HEADER_CONTENT_ENCODING = "content-encoding";
    static final String HTTP_HEADER_TRANSFER_ENCODING = "transfer-encoding";
    static final String HTTP_HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    static final int DEFAULT_PROXY_PORT = 80;
    static final int DEFAULT_HTTPS_PORT = 443;
    static final int DEFAULT_HTTP_PORT = 80;

    private Utils() {
    }

    static final int escapeHtmlFull(int ch) {
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57) {
            return ch;
        }
        if (Character.isWhitespace(ch)) {
            if (ch != 10 && ch != 13 && ch != 9) {
                return ch;
            }
        } else {
            if (Character.isDefined(ch)) {
                return ch;
            }
            if (Character.isISOControl(ch)) {
                return -1;
            }
            if (Character.isHighSurrogate((char)ch)) {
                return -1;
            }
            if (Character.isLowSurrogate((char)ch)) {
                return -1;
            }
        }
        return -1;
    }

    static final String getProxyHostAndPort(ProxyInfo proxyInfo) {
        if (proxyInfo.getProxyPort() == 80) {
            return proxyInfo.getProxyHost();
        }
        return proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort();
    }

    static final Set<String> parseWhiteList(String property) {
        if (property != null) {
            HashSet<String> set = new HashSet<String>();
            String[] array = property.split(",");
            for (int i = 0; i < array.length; ++i) {
                String element = array[i];
                if (element == null) continue;
                set.add(element);
            }
            return set;
        }
        return null;
    }

    static URL buildURL(String value) throws MalformedURLException {
        URL url = new URL(value);
        if (url.getPort() == -1) {
            if (url.getProtocol().equals("https")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info("Using default HTTPS port: 443");
                }
                return new URL(url.getProtocol(), url.getHost(), 443, url.getFile());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Using default HTTP port: 80");
            }
            return new URL(url.getProtocol(), url.getHost(), 80, url.getFile());
        }
        return url;
    }
}

